-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['movf'] = 0
  electrics.values['movf_input'] = 0
  electrics.values['movr'] = 0
  electrics.values['movr_input'] = 0
end

local function updateGFX(dt) -- ms
  electrics.values['movf'] = math.min(1, math.max(-1, (electrics.values['movf'] + electrics.values['movf_input'] * dt * 1)))
  electrics.values['movr'] = math.min(1, math.max(-1, (electrics.values['movr'] + electrics.values['movr_input'] * dt * 1)))
end

local function movfRoof(value)
  electrics.values.movf_input = value
end

local function movrRoof(value)
  electrics.values.movf_input = value
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.movfRoof = movfRoof
M.movrRoof = movrRoof

return M
