-- Written by Miata lover
-- Do not reuse or modify without permission!
local M = {}

local timer = 0
local wiperMode = 0
local wiperModeR = 0
local wiperModeH = 0
local wiperModeTemp = 0
local wiperSleep = 0
local wiperT = 0
local wiperTR = 0
local wiperTH = 0
local wiperSpeed = 1
local wiperSpeedTemp = 0
local wiperSpeedR = 1
local wiperSpeedH = 1.5
local ignitionIndependent
local wiperProfile
local hasRearWiper = false
local hasHeadlightWiper = false
local wiperOffset
local wipersNode
local wipersNodeHeadlight
local wipersSound
local wipersSoundR
local wipersSoundH
local soundVolume
local soundVolumeH
local speedMult

local stalkSmoother = newExponentialSmoothing(10)

local function init(jbeamData)
  electrics.values.wiperVal = 0
  electrics.values.wipers = 0
  if jbeamData.hasRearWiper then
    hasRearWiper = true
    electrics.values.wiperValR = 0
  end
  if jbeamData.hasHeadlightWiper then
    hasHeadlightWiper = true
    electrics.values.wiperValH = 0
  end
  if jbeamData.wiperOffset then
    wiperOffset = jbeamData.wiperOffset
    electrics.values.wiperVal2 = 0
  end
  speedMult = jbeamData.speedMult or 1
  wipersNode = jbeamData.wipersNode or nil
  wipersNodeHeadlight = jbeamData.wipersNodeHeadlight or nil
  ignitionIndependent = jbeamData.ignitionIndependent or false
  wiperProfile = jbeamData.wiperProfile or "normal"

  for v, n in pairs(v.data.nodes) do
    if n.name == wipersNode then
      wipersNode = v
    elseif n.name == wipersNodeHeadlight then
      wipersNodeHeadlight = v
    end
  end
  
  if wipersNode == jbeamData.wipersNode then
    log("W", "controller.animatedWipers", "failed to find node: " .. wipersNode .. ". Using RefNode Instead.") 
    wipersNode = v.data.refNodes[0].ref
  end
  if wipersNodeHeadlight == jbeamData.wipersNodeHeadlight then
    log("W", "controller.animatedWipers", "failed to find node: " .. wipersNodeHeadlight .. ". Using RefNode Instead.") 
    wipersNodeHeadlight = v.data.refNodes[0].ref
  end
end

local function reset()
  wiperT = 0
  wiperTR = 0
  wiperTH = 0
end

local function updateGFX(dt)
  if electrics.values.ignitionLevel ~= 0 or ignitionIndependent then
    -- Front
    if wiperT <= 0 then
      wiperT = 0
      if wiperMode == 4 then
        if wiperSpeed < 0 then
          wiperMode = wiperModeTemp
          wiperSpeed = wiperSpeedTemp
          timer = 0
        else
          wiperSpeedTemp = wiperSpeed
          wiperSpeed = 2
          wiperT = wiperT + dt * wiperSpeed
          M.playSound(wiperSpeed)
        end
      elseif wiperMode ~= 0 then
        if wiperSpeed < 0 then
          wiperSpeed = -wiperSpeed
          timer = 0
        end
        if timer >= wiperSleep then
          wiperT = wiperT + dt * wiperSpeed
          M.playSound(wiperSpeed)
        end
      end
    else
      if wiperT >= 1 then 
        wiperT = 1
        wiperSpeed = -wiperSpeed 
      end
      wiperT = wiperT + dt * wiperSpeed
    end
    
    -- Rear
    if hasRearWiper then
      if wiperTR <= 0 then
        wiperTR = 0
        if wiperModeR == 1 then
          if wiperSpeedR < 0 then
            wiperSpeedR = -wiperSpeedR
          end
          wiperTR = wiperTR + dt * wiperSpeedR
          M.playSoundR(wiperSpeedR)
        end
      else
        if wiperTR >= 1 then
          wiperTR = 1
          wiperSpeedR = -wiperSpeedR
        end
        wiperTR = wiperTR + dt * wiperSpeedR
      end
    end
    
    -- Headlight
    if hasHeadlightWiper then
      if wiperTH <= 0 then
        wiperTH = 0
        if wiperModeH == 1 then
          if wiperSpeedH < 0 then
            wiperSpeedH = -wiperSpeedH
          end
          wiperTH = wiperTH + dt * wiperSpeedH
          M.playSoundH(wiperSpeedH)
        end
      else
        if wiperTH >= 1 then
          wiperTH = 1
          wiperSpeedH = -wiperSpeedH
        end
        wiperTH = wiperTH + dt * wiperSpeedH
      end
    end

    if wiperProfile == "normal" then
      electrics.values.wiperVal = M.EaseInOut(wiperT)
    elseif wiperProfile == "race" then
      electrics.values.wiperVal = M.EaseInOut2(wiperT)
    end
    if hasRearWiper then electrics.values.wiperValR = M.EaseInOut(wiperTR) end
    if hasHeadlightWiper then electrics.values.wiperValH = M.EaseInOut(wiperTH) end
    if wiperOffset then electrics.values.wiperVal2 = M.EaseInOut(wiperT + wiperOffset) end
    
    timer = timer + dt
  end
  
  if wipersSound then
    obj:setVolumePitch(wipersSound, M.SoundVol(), math.abs(wiperSpeed)) 
  end
  if wipersSoundR then
    obj:setVolumePitch(wipersSoundR, M.SoundVol(), 1) 
  end
  if wipersSoundH then
    obj:setVolumePitch(wipersSoundH, M.SoundVolH(), math.abs(wiperSpeedH)) 
  end
    
  if wiperMode ~= 4 then electrics.values.wipers = stalkSmoother:get(wiperMode / 3) end
end

local function toggleMode()
  if wiperMode == 0 then
    wiperMode = 1
    wiperSleep = 4
    if wiperSpeed < 0 then wiperSpeed = -1.4 * speedMult else wiperSpeed = 1.4 * speedMult end
    timer = wiperSleep
    gui.message("Wipers: Slow", 2, "wiperMsg")
  elseif wiperMode == 1 then
	  wiperMode = 2
    wiperSleep = 1
    if wiperSpeed < 0 then wiperSpeed = -1.4 * speedMult else wiperSpeed = 1.4 * speedMult end
    gui.message("Wipers: Medium", 2, "wiperMsg")
  elseif wiperMode == 2 then
	  wiperMode = 3
    wiperSleep = 0
    if wiperSpeed < 0 then wiperSpeed = -1.8 * speedMult else wiperSpeed = 1.8 * speedMult end
    gui.message("Wipers: Fast", 2, "wiperMsg")
  elseif wiperMode == 3 then
	  wiperMode = 0
    gui.message("Wipers: Off", 2, "wiperMsg")
  end  
end

local function setMode(mode)
  if mode == 1 then
    wiperMode = 1
    wiperSleep = 4
    if wiperSpeed < 0 then wiperSpeed = -1.4 * speedMult else wiperSpeed = 1.4 * speedMult end
    timer = wiperSleep
    gui.message("Wipers: Slow", 2, "wiperMsg")
  elseif mode == 2 then
	  wiperMode = 2
    wiperSleep = 1
    if wiperSpeed < 0 then wiperSpeed = -1.4 * speedMult else wiperSpeed = 1.4 * speedMult end
    gui.message("Wipers: Medium", 2, "wiperMsg")
  elseif mode == 3 then
	  wiperMode = 3
    wiperSleep = 0
    if wiperSpeed < 0 then wiperSpeed = -1.8 * speedMult else wiperSpeed = 1.8 * speedMult end
    gui.message("Wipers: Fast", 2, "wiperMsg")
  elseif mode == 0 then
	  wiperMode = 0
    gui.message("Wipers: Off", 2, "wiperMsg")
  end  
end

local function toggleModeR()
  if hasRearWiper then
    if wiperModeR == 0 then
      wiperModeR = 1
      gui.message("Rear Wiper: On", 2, "wiperMsgR")
    else
      wiperModeR = 0
      gui.message("Rear Wiper: Off", 2, "wiperMsgR")
    end
  end
end

local function setModeR(mode)
  if hasRearWiper then
    if mode == 1 then
      wiperModeR = 1
      gui.message("Rear Wiper: On", 2, "wiperMsgR")
    elseif mode == 0 then
      wiperModeR = 0
      gui.message("Rear Wiper: Off", 2, "wiperMsgR")
    end
  end
end

local function toggleModeH()
  if hasHeadlightWiper then
    if wiperModeH == 0 then
      wiperModeH = 1
      gui.message("Headlight Wipers: On", 2, "wiperMsgH")
    else
      wiperModeH = 0
      gui.message("Headlight Wipers: Off", 2, "wiperMsgH")
    end
  end
end

local function setModeH(mode)
  if hasHeadlightWiper then
    if mode == 1 then
      wiperModeH = 1
      gui.message("Headlight Wipers: On", 2, "wiperMsgH")
    elseif mode == 0 then
      wiperModeH = 0
      gui.message("Headlight Wipers: Off", 2, "wiperMsgH")
    end
  end
end

local function wipe()
  if wiperMode ~= 4 then
    wiperModeTemp = wiperMode
    wiperMode = 4
  end
end

local function playSound(pitch)
  if not wipersSound then wipersSound = obj:createSFXSource2("art/sound/wiper.wav", "AudioClosest3D", "wiperSound", wipersNode, 0) end
  obj:setVolumePitch(wipersSound, 1, pitch) 
  obj:playSFX(wipersSound)
end

local function playSoundR(pitch)
  if not wipersSoundR then wipersSoundR = obj:createSFXSource2("art/sound/wiper.wav", "AudioClosest3D", "wiperSound", wipersNode, 0) end
  obj:setVolumePitch(wipersSoundR, 1, pitch) 
  obj:playSFX(wipersSoundR)
end

local function playSoundH(pitch)
  if not wipersSoundH then wipersSoundH = obj:createSFXSource2("art/sound/wiper.wav", "AudioClosest3D", "wiperSound", wipersNodeHeadlight, 0) end
  obj:setVolumePitch(wipersSoundH, 1, pitch) 
  obj:playSFX(wipersSoundH)
end

local function SoundVol()
  local camPos = obj:getCameraPosition()
  local combinedPos = obj:getPosition() + obj:getNodePosition(beamstate.nodeNameMap['driver'] or 0)

  if camPos and combinedPos then
      return math.min(0.5, 0.5/camPos:distance(combinedPos))
  end
end

local function SoundVolH()
  local camPos = obj:getCameraPosition()
  local combinedPos = obj:getPosition() + obj:getNodePosition(wipersNodeHeadlight or 0)

  if camPos and combinedPos then
      return math.min(1, 1/camPos:distance(combinedPos))
  end
end

local function EaseInOut(t)
  if t < 0 then return 0 end
  return -0.5 * (math.cos(math.pi * t) - 1)
end

local function EaseInOut2(t)
  if t < 0 then return 0.5 end
  if wiperSpeed > 0 then 
    return -0.5 * (math.sin(math.pi * t) - 1)
  else 
    return 0.5 * (math.sin(math.pi * t) + 1)
  end
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.toggleMode = toggleMode
M.toggleModeR = toggleModeR
M.toggleModeH = toggleModeH
M.setMode = setMode
M.setModeR = setModeR
M.setModeH = setModeH
M.wipe = wipe
M.SoundVol = SoundVol
M.SoundVolH = SoundVolH
M.playSound = playSound
M.playSoundR = playSoundR
M.playSoundH = playSoundH
M.EaseInOut = EaseInOut
M.EaseInOut2 = EaseInOut2
return M