-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

-- Credit to the great aljowen for help with the code - 13Stewartc

local counter = 0
local counterlimit = 0.5
local throttleInputs = {0, 1, 1, 1, 1, 0.5, 0.1, 0.3}
local timer = 0
local enableRevLimiter = false
local revLimiterLimit = 2500
local revLowerLimit = 2400
local revLimited = false

local function updateGFX(dt)

	
	local rpm = math.floor( electrics.values.rpm + 0.5 or 0)
	local value = math.random(1, #throttleInputs)
	local pickedInput = throttleInputs[value]
	
	-- Check Engine Light Controller (Controls the flashing of the check engine light when further damage is done)
	if electrics.values.checkengine == true then
		if counter > counterlimit then
			if electrics.values.fakeCheckEngine == 1 then
				electrics.values.fakeCheckEngine = 0
			else
				electrics.values.fakeCheckEngine = 1
			end
			counter = 0
		end
		counter = counter + dt
	end
	-- Controls the throttle input whilst accelerating to create hesitation when accelerating.
	if electrics.values.throttle > 0.1 and rpm > revLimiterLimit and enableRevLimiter == false then
		electrics.values.throttle = pickedInput
		timer = timer + dt
		
		-- Puts engine in limp mode
		if rpm > 5000 and timer > 10 then
			enableRevLimiter = true
		end
	end
	-- Controls the throttle in limp mode
	if enableRevLimiter == true then
		-- enables the rev limiter (limp mode rev limiter)
		if revLimited == false then
			if rpm > revLimiterLimit then 
				revLimited = true
			end
		else
			if rpm < revLowerLimit then
				revLimited = false
			end
		end
		if revLimited == true then
			electrics.values.throttle = 0
		end
		-- If the engine is turned off then disable the rev limiter
		if electrics.values.ignition == false then
			enableRevLimiter = false
			timer = 0
		end
	end
end

local function onReset()
	enableRevLimiter = false
	timer = 0
end

local function init(data)
	electrics.values.fakeCheckEngine = 1	
end


M.init = init
M.updateGFX = updateGFX
M.reset = onReset

return M
