local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local adjustSpeed = 0.5

local pressureTargetRear = 500
local pressureTargetFront = 500
local frontUp = false
local rearUp = false

local rearHold = false
local rearTimer = false
local rearTime = 0
local rearTimeGoal = 1
local rearBeginDown = false
local rearHoldLastFrame = false

local frontHold = false
local frontTimer = false
local frontTime = 0
local frontTimeGoal = 1
local frontHoldLastFrame = false

local maxPressure = 500


--audio variables
local sound
local playingSFX = false
local sfxStage = 0 -- 0 = Initial, 1 = Loop
local sfxTimer = 0

local playingSFX_front = false
local sfxStage_front = 0 -- 0 = Initial, 1 = Loop
local sfxTimer_front = 0

local stageOneTarget = 0.2
local stageThreeTarget = 0.5


local oneShotTimer = 0
local oneShotTarget = 2
local oneShotIsPlaying = false

-- Credit to the great aljowen for help with the code - 13Stewartc
local function playPTSLoop()

	obj:playSFX(snd_rearBegin)
	playingSFX = true
	sfxStage = 0
	sfxTimer = 0

end

local function playPTSLoop2()

	obj:playSFX(snd_frontBegin)
	playingSFX_front = true
	sfxStage_front = 0
	sfxTimer_front = 0

end

local function updateGFX(dt)
	-- REAR
	if electrics.values.rearSus == 1 then
		rearHold = not rearHold
		electrics.values.rearSus = 0
		if rearHold == true and rearHoldLastFrame == false then
			playPTSLoop()
			
		end
	end
	if rearTimer == true then
		rearTime = rearTime + dt
		if rearTime > rearTimeGoal then
			rearTimer = false
			rearTime = 0
		end
	else

		if rearHold then
			if rearUp == true then
				pressureTargetRear = pressureTargetRear + adjustSpeed*0.64
				if pressureTargetRear > maxPressure then
					rearUp = false
					rearTimer = true
					playPTSLoop()
				end
			else
				pressureTargetRear = pressureTargetRear - adjustSpeed*0.64
				if pressureTargetRear < 330 then
					rearUp = true
					rearTimer = true
				end
			end
			controller.getControllerSafe('airbagsR').setBeamPressure({'rearrightAxle'}, pressureTargetRear)
			controller.getControllerSafe('airbagsR').setBeamPressure({'rearleftAxle'}, pressureTargetRear)	
		end
	end
	
	rearHoldLastFrame = rearHold

	-- FRONT 
	if electrics.values.frontSus == 1 then
		frontHold = not frontHold
		electrics.values.frontSus = 0
		
		if frontHold == true and frontHoldLastFrame == false then
			playPTSLoop2()
		end
	end
	if frontTimer == true then
		frontTime = frontTime + dt
		if frontTime > frontTimeGoal then
			frontTimer = false
			frontTime = 0
		end
	else
		
		
		
		if frontHold then
			if frontUp == true then
				pressureTargetFront = pressureTargetFront + adjustSpeed
				if pressureTargetFront > maxPressure then
					frontUp = false
					frontTimer = true
					playPTSLoop2()
				end
			else
				pressureTargetFront = pressureTargetFront - adjustSpeed
				if pressureTargetFront < 235 then
					frontUp = true
					frontTimer = true
				end
			end
			controller.getControllerSafe('airbagsF').setBeamPressure({'frontrightAxle'}, pressureTargetFront)
			controller.getControllerSafe('airbagsF').setBeamPressure({'frontleftAxle'}, pressureTargetFront)	
		end
	end

	frontHoldLastFrame = frontHold

	-- LEVEL SUSPENSION
	if electrics.values.levelSus == 1 then
		local level = (pressureTargetFront + pressureTargetRear)/2
		local oldPressureTargetFront = pressureTargetFront
		local oldPressureTargetRear = pressureTargetRear
		
		pressureTargetFront = level + ((level - 500)/170)*50
		pressureTargetRear = level - ((level - 500)/170)*50
		
		local rearSoundTime = (oldPressureTargetRear - pressureTargetRear)/170
		
		if rearSoundTime > 0 then
		
			oneShotTimer = 2 - rearSoundTime
			oneShotIsPlaying = true
			obj:playSFX(sound)	
		else	
		
			oneShotTimer = 2- (oldPressureTargetFront - pressureTargetFront)/265
			oneShotIsPlaying = true
			obj:playSFX(sound)	
		end
		
		if level < 330 then level = 330 end
		
		controller.getControllerSafe('airbagsF').setBeamPressure({'frontrightAxle'}, pressureTargetFront)
		controller.getControllerSafe('airbagsF').setBeamPressure({'frontleftAxle'}, pressureTargetFront)
		controller.getControllerSafe('airbagsR').setBeamPressure({'rearrightAxle'}, pressureTargetRear)
		controller.getControllerSafe('airbagsR').setBeamPressure({'rearleftAxle'}, pressureTargetRear)
		electrics.values.levelSus = 0
	end
	-- RAISE TO MAXIMUM
	if electrics.values.raiseSus == 1 then
		local level = maxPressure
		pressureTargetFront = level
		pressureTargetRear = level
		
		controller.getControllerSafe('airbagsF').setBeamPressure({'frontrightAxle'}, level)
		controller.getControllerSafe('airbagsF').setBeamPressure({'frontleftAxle'}, level)
		controller.getControllerSafe('airbagsR').setBeamPressure({'rearrightAxle'}, level)
		controller.getControllerSafe('airbagsR').setBeamPressure({'rearleftAxle'}, level)
		electrics.values.raiseSus = 0
	end
	-- LOWER TO MINIMUM
	if electrics.values.lowerSus == 1 then
		local rearlevel = 330
		local frontLevel = 235

		oneShotTimer = 2 - (((pressureTargetRear - 330)/170)+((pressureTargetFront - 235)/265))
		
		if oneShotTimer < 1.9 then
			oneShotIsPlaying = true
			obj:playSFX(sound)	
		end
		pressureTargetFront = frontLevel
		pressureTargetRear = rearlevel	
		
		controller.getControllerSafe('airbagsF').setBeamPressure({'frontrightAxle'}, frontLevel)
		controller.getControllerSafe('airbagsF').setBeamPressure({'frontleftAxle'}, frontLevel)
		controller.getControllerSafe('airbagsR').setBeamPressure({'rearrightAxle'}, rearlevel)
		controller.getControllerSafe('airbagsR').setBeamPressure({'rearleftAxle'}, rearlevel)
		electrics.values.lowerSus = 0
	
	end
	
    -- STEERING OVER-RIDE
	if pressureTargetFront < 290 then
		electrics.values.steering_input = 0
		electrics.values.clutchRatio = 0
	end
	
	-- Lowering Audio (PTS)
	if oneShotIsPlaying == true then
		if oneShotTimer > oneShotTarget then
			oneShotIsPlaying = false
			obj:stopSFX(sound)
		end
		oneShotTimer = oneShotTimer + dt
	end
	
	-- REAR
	if playingSFX then
		if sfxStage == 0 then
			if sfxTimer > stageOneTarget then
				sfxStage = 1
				obj:stopSFX(snd_rearBegin)
				obj:playSFX(snd_rearLoop)
				sfxTimer = 0
			else
				sfxTimer = sfxTimer + dt
			end
		end
		if sfxStage == 1 then
			if rearHold == false or rearUp == true then
				obj:stopSFX(snd_rearLoop)
				playingSFX = false
			end
		end
	end
	-- FRONT
	if playingSFX_front then
		if sfxStage_front == 0 then
			if sfxTimer_front > stageOneTarget then
				sfxStage_front = 1
				obj:stopSFX(snd_frontBegin)
				obj:playSFX(snd_frontLoop)
				sfxTimer_front = 0
			else
				sfxTimer_front = sfxTimer_front + dt
			end
		end
		if sfxStage_front == 1 then
			if frontHold == false or frontUp == true then
				obj:stopSFX(snd_frontLoop)
				playingSFX_front = false
			end
		end
	end
end



local function reset()
	pressureTargetRear = maxPressure
	pressureTargetFront = maxPressure
	rearUp = false
	frontUp = false
	rearHold = false
	frontHold = false

	rearTimer = false
	rearTime = 0

	frontTimer = false
	frontTime = 0
end

local function init()
	pressureTargetRear = maxPressure
	pressureTargetFront = maxPressure
	rearUp = false
	frontUp = false
	rearHold = false
	frontHold = false
	
	rearTimer = false
	rearTime = 0
	
	frontTimer = false
	frontTime = 0	
end

local function  initSounds()
	-- One Shot Sound
	sound = obj:createSFXSource2("art/sound/air_ride_pts_loop.wav","AudioDefaultLoop3D","",108,0)
	obj:setVolumePitch(sound,0.5,1)
	-- Rear Sounds
	snd_rearBegin = obj:createSFXSource2("art/sound/air_ride_pts.wav","AudioDefaultLoop3D","",310,0)
	snd_rearLoop = obj:createSFXSource2("art/sound/air_ride_pts_loop.wav","AudioDefaultLoop3D","",310,0)
	obj:setVolumePitch(snd_rearBegin,0.5,1)
	obj:setVolumePitch(snd_rearLoop,0.5,1)
	
	-- Front Sounds
	snd_frontBegin = obj:createSFXSource2("art/sound/air_ride_pts.wav","AudioDefaultLoop3D","",205,0)
	snd_frontLoop = obj:createSFXSource2("art/sound/air_ride_pts_loop.wav","AudioDefaultLoop3D","",205,0)
	obj:setVolumePitch(snd_frontBegin,0.5,1)
	obj:setVolumePitch(snd_frontLoop,0.5,1)
end

M.init = init
M.initSounds = initSounds
M.updateGFX = updateGFX
M.reset = reset

return M