local latchPulseController = {}

local latchAnimations = {}

-- Define all your latch settings here!
local latchSettings = {
    -- latchVar = {rampIn, hold, rampOut, curveInType, curveInPow, curveOutType, curveOutPow}
    door_FL =    {rampIn=0.1, hold=1, rampOut=1, curveInType="easein", curveInPow=2, curveOutType="easeout", curveOutPow=2},
    rearLatch =  {rampIn=0.15, hold=0.5, rampOut=0.8, curveInType="linear", curveOutType="easeout", curveOutPow=2},
    -- Add more latches here!
}

function latchPulseController.init(jbeamData)
    latchAnimations = {}
end

local function getCurveValue(progress, curveType, curvePow)
    if curveType == "easein" then
        return progress ^ (curvePow or 2)
    elseif curveType == "easeout" then
        return 1 - (1 - progress) ^ (curvePow or 2)
    elseif curveType == "custom" and curvePow then
        return progress ^ curvePow
    else -- linear
        return progress
    end
end

function latchPulseController.updateGFX(dt)
    for name, anim in pairs(latchAnimations) do
        if anim.active then
            anim.time = anim.time + dt

            if anim.time < anim.rampIn then
                local progress = anim.time / anim.rampIn
                electrics.values[name] = getCurveValue(progress, anim.curveInType, anim.curveInPow)
            elseif anim.time < anim.rampIn + anim.hold then
                electrics.values[name] = 1
            elseif anim.time < anim.rampIn + anim.hold + anim.rampOut then
                local progress = (anim.time - anim.rampIn - anim.hold) / anim.rampOut
                electrics.values[name] = 1 - getCurveValue(progress, anim.curveOutType, anim.curveOutPow)
            else
                electrics.values[name] = 0
                anim.active = false
            end
        end
    end
end

-- Now, you ONLY pass the variable name!
function latchPulseController.pulse(name)
    local s = latchSettings[name] or {} -- use table or empty
    latchAnimations[name] = {
        active = true,
        time = 0,
        rampIn = s.rampIn or 0.1,
        hold = s.hold or 1,
        rampOut = s.rampOut or 1,
        curveInType = s.curveInType or "linear",
        curveInPow = s.curveInPow,
        curveOutType = s.curveOutType or "linear",
        curveOutPow = s.curveOutPow
    }
    electrics.values[name] = 0
end
function latchPulseController.reset(jbeamData)
    for name, _ in pairs(latchSettings) do
        electrics.values[name] = 0
    end
    latchAnimations = {}
end
return latchPulseController
