-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- http://beamng.com/bCDDL-1.1.txt

local M = {}

local function init(jbeamData)
  print(">> Airbag controller INIT successful <<")
end

local function onInit()
  electrics.values.airbag_input = 0
end

local function onReset()
  electrics.values.airbag_input = 0
end

local function updateGFX(dt)
  local input = electrics.values.airbag_input or 0

  --  Use global context where `actuators` is available
  if actuators and type(actuators.setBeamGroupValveState) == "function" then
    actuators.setBeamGroupValveState("mainAxles", input)
  end

  -- Get tank pressure from mainAirTank
  local tank = energyStorage.getStorage and energyStorage.getStorage("mainAirTank")
  if tank and tank.currentPressure then
    local psi = (tank.currentPressure - 101325) * 0.000145038
    electrics.values.air_tank_psi = psi -- optional visual output

    --  Control throttle based on PSI
    if psi < 90 then
      electrics.values.throttle = 1
    elseif psi > 120 then
      electrics.values.throttle = 0
    end
  end
end

local function setAirbagInput(value)
  electrics.values.airbag_input = math.max(-1, math.min(1, value))
end

M.init = init
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX
M.setAirbagInput = setAirbagInput

return M
