local M = {}
M.type = "auxiliary"

local whooshSound = nil
local throttle = 0
local engineRunning = 0
local volume = 0
local targetVolume = 0
local isPlaying = false

local function init(jbeamData)
end

local function updateGFX(dt)
  throttle = electrics.values.throttle or 0
  engineRunning = electrics.values.engineRunning or 0

  local rpm = electrics.values.rpm or 0
  local rpmMin = 800     -- idle
  local rpmMax = 8000    -- redline
  local rpmFactor = math.min(math.max((rpm - rpmMin) / (rpmMax - rpmMin), 0), 1)

  if engineRunning == 1 and throttle > 0 then
    targetVolume = 0.2 + rpmFactor * 3.8
  else
    targetVolume = 0
  end

  -- Smoothly blend volume
  volume = volume + (targetVolume - volume) * math.min(dt * 10, 1)

  -- Create sound if needed
  if not whooshSound then
    whooshSound = sounds.createSoundscapeSound("intakeWhoosh")
    if not whooshSound then
      print("INTAKE DEBUG: Failed to create sound!")
      return
    end
  end

  -- Always play when engine is on, even if volume starts at 0
  if engineRunning == 1 and not isPlaying then
    obj:playSFX(whooshSound)
    isPlaying = true
  end

  -- Adjust volume/pitch while running
  if engineRunning == 1 and isPlaying then
    obj:setVolume(whooshSound, volume)
    obj:setPitch(whooshSound, 0.9 + rpmFactor * 0.2)
  end

  -- Fully stop if engine off
  if engineRunning == 0 and isPlaying then
    obj:setVolume(whooshSound, 0)
    obj:stopSFX(whooshSound)
    isPlaying = false
  end
end

local function reset()
  volume = 0
  targetVolume = 0
  if whooshSound then
    obj:stopSFX(whooshSound)
    whooshSound = nil
  end
  isPlaying = false
end

M.init = init
M.updateGFX = updateGFX
M.reset = reset

return M
