local M = {}
M.type = "auxiliary"

local fuelPumpSound = nil
local lastIgnitionLevel = 0
local lastEngineRunning = 0
local soundTimer = 0
local shutdownTimer = 0
local crankTimer = 0
local state = "off" -- states: off, short, long, shutdown, crank_waiting

local function init(jbeamData)
end

local function updateGFX(dt)
  local ignition = electrics.values.ignitionLevel or 0
  local engineRunning = electrics.values.engineRunning or 0

  -- 💥 Kill everything if ignition is off
  if ignition == 0 then
    if fuelPumpSound then
      obj:setVolume(fuelPumpSound, 0)
      obj:stopSFX(fuelPumpSound)
    end
    fuelPumpSound = nil
    shutdownTimer = 0
    crankTimer = 0
    state = "off"
    lastIgnitionLevel = ignition
    lastEngineRunning = engineRunning
    return
  end

  -- 🔄 Prime burst at ignition level 1
  if ignition == 1 and lastIgnitionLevel < 1 then
    fuelPumpSound = fuelPumpSound or sounds.createSoundscapeSound("fuelpump")
    if fuelPumpSound then
      obj:setVolume(fuelPumpSound, 0)
      obj:playSFX(fuelPumpSound)
      obj:setVolume(fuelPumpSound, 1.5)
      soundTimer = 2.0
      state = "short"
    end
  end

  -- ⏲ Prime timer
  if state == "short" then
    soundTimer = soundTimer - dt
    if soundTimer <= 0 then
      obj:setVolume(fuelPumpSound, 0)
      obj:stopSFX(fuelPumpSound)
      fuelPumpSound = nil
      state = "off"
    end
  end

  -- 🔁 Cranking only: set timeout
  if ignition == 3 and engineRunning == 0 and state ~= "crank_waiting" then
    fuelPumpSound = fuelPumpSound or sounds.createSoundscapeSound("fuelpump")
    if fuelPumpSound then
      obj:setVolume(fuelPumpSound, 0)
      obj:playSFX(fuelPumpSound)
      obj:setVolume(fuelPumpSound, 1.5)
      crankTimer = 2.0
      state = "crank_waiting"
    end
  end


  if state == "crank_waiting" then
    crankTimer = crankTimer - dt
    if engineRunning == 1 then
      state = "long" -- transition to normal running
    elseif crankTimer <= 0 then
      obj:setVolume(fuelPumpSound, 0)
      obj:stopSFX(fuelPumpSound)
      fuelPumpSound = nil
      state = "off"
    end
  end

 
  if engineRunning == 1 and state ~= "long" then
    fuelPumpSound = fuelPumpSound or sounds.createSoundscapeSound("fuelpump")
    if fuelPumpSound then
      obj:setVolume(fuelPumpSound, 0)
      obj:playSFX(fuelPumpSound)
      obj:setVolume(fuelPumpSound, 1.5)
      state = "long"
    end
  end


  if fuelPumpSound and state == "long" then
    local rpm = electrics.values.rpm or 0
    local pitch = 1.0 + (rpm / 12000)
    obj:setPitch(fuelPumpSound, math.min(pitch, 2.0))
  end


  if lastEngineRunning == 1 and engineRunning == 0 and ignition > 0 then
    shutdownTimer = 2.0
    state = "shutdown"
  end


  if state == "shutdown" then
    shutdownTimer = shutdownTimer - dt
    if shutdownTimer <= 0 then
      if fuelPumpSound then
        obj:setVolume(fuelPumpSound, 0)
        obj:stopSFX(fuelPumpSound)
      end
      fuelPumpSound = nil
      state = "off"
    end
  end

  lastIgnitionLevel = ignition
  lastEngineRunning = engineRunning
end

local function reset()
  lastIgnitionLevel = 0
  lastEngineRunning = 0
  soundTimer = 0
  shutdownTimer = 0
  crankTimer = 0
  state = "off"
  if fuelPumpSound then
    obj:setVolume(fuelPumpSound, 0)
    obj:stopSFX(fuelPumpSound)
    fuelPumpSound = nil
  end
end

M.init = init
M.updateGFX = updateGFX
M.reset = reset

return M
