local M = {}

local Color = "RGB"

local function onInit()
  electrics.values['toggle_multicolor'] = 0
  electrics.values['multicolor_input'] = 1
  Color = "RGB"
end

local time = 1
local function getPositiveAngleDiff(a, b)
    return a < b and a+360-b or a-b
end
-- returns r, g and b
local function getRainbowRGB(num)
    local angle = num*360
    local components = {}
    for i = 1, 3 do
        local startAngle = ((i+1)*120)%360
        local diffFromStart = getPositiveAngleDiff(angle, startAngle)
        if diffFromStart < 60 then
            components[i] = diffFromStart/60*255
        elseif diffFromStart <= 180 then
            components[i] = 255
        elseif diffFromStart < 240 then
            components[i] = (240-diffFromStart)/60*255
        else
            components[i] = 0
        end
    end
    return components[1], components[2], components[3]
end

local function updateGFX(dt)

	if electrics.values['multicolor_input'] == 1 then
	  time = time + dt
	  local COLOR_1, COLOR_2, COLOR_3 = getRainbowRGB(time)
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	  if time > 1 then
		time = 0
	  end
	end	
	if electrics.values['multicolor_input'] == 2 then
	  time = 0
	  local COLOR_1 = 1000
	  local COLOR_2 = 0
	  local COLOR_3 = 0
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
	if electrics.values['multicolor_input'] == 3 then
	  time = 0
	  local COLOR_1 = 0
	  local COLOR_2 = 1000
	  local COLOR_3 = 0
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
	if electrics.values['multicolor_input'] == 4 then
	  time = 0
	  local COLOR_1 = 0
	  local COLOR_2 = 0
	  local COLOR_3 = 1000
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
	if electrics.values['multicolor_input'] == 5 then
	  time = 0
	  local COLOR_1 = 1000
	  local COLOR_2 = 1000
	  local COLOR_3 = 1000
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
	if electrics.values['multicolor_input'] == 6 then
	  time = 0
	  local COLOR_1 = 1000
	  local COLOR_2 = 1000
	  local COLOR_3 = 0
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
	if electrics.values['multicolor_input'] == 7 then
	  time = 0
	  local COLOR_1 = 0
	  local COLOR_2 = 500
	  local COLOR_3 = 500
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
	if electrics.values['multicolor_input'] == 8 then
	  time = 0
	  local COLOR_1 = 1000
	  local COLOR_2 = 0
	  local COLOR_3 = 1000
	  obj:queueGameEngineLua("scripts_rgb_extension.rainbow_Mode(" .. COLOR_1 .. "," .. COLOR_2 .. "," .. COLOR_3 .. ")")
	end	
end

local function multicolor_toggle()
	if electrics.values['multicolor_input'] < 8 then
	
		electrics.values['multicolor_input'] = electrics.values['multicolor_input'] + 1
		
	else
	
		electrics.values['multicolor_input'] = 1
	
	end
		if electrics.values['multicolor_input'] == 1 then
			guihooks.message("RGB mode changed! Now showing: RGB ", 5, "RGB_mode")
		end
		
		if electrics.values['multicolor_input'] == 2 then
			guihooks.message("RGB mode changed! Now showing: Red ", 5, "RGB_mode")
		end
		
		if electrics.values['multicolor_input'] == 3 then
			guihooks.message("RGB mode changed! Now showing: Green ", 5, "RGB_mode")
		end
			
		if electrics.values['multicolor_input'] == 4 then
			guihooks.message("RGB mode changed! Now showing: Blue ", 5, "RGB_mode")
		end
			
		if electrics.values['multicolor_input'] == 5 then
			guihooks.message("RGB mode changed! Now showing: White ", 5, "RGB_mode")
		end
			
		if electrics.values['multicolor_input'] == 6 then
			guihooks.message("RGB mode changed! Now showing: Yellow ", 5, "RGB_mode")
		end
			
		if electrics.values['multicolor_input'] == 7 then
			guihooks.message("RGB mode changed! Now showing: Cyan ", 5, "RGB_mode")
		end
			
		if electrics.values['multicolor_input'] == 8 then
			guihooks.message("RGB mode changed! Now showing: Purple ", 5, "RGB_mode")
		end
end



M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX
M.rainbow_Mode = rainbow_Mode
M.multicolor_toggle = multicolor_toggle
M.getRainbowRGB = getRainbowRGB


return M
