-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local nitrousfiretime
local nitrousfirecooldown
local firetime
local firecooldown


local function onInit()
    electrics.values['nitrous_flames_one'] = 0
	electrics.values['nitrous_flames_two'] = 0
	nitrousfiretime = 0
	nitrousfirecooldown = 0
	firetime = 0
	firecooldown = 0
end




local function updateGFX(dt)

    --disable all fire under water
	for k, _ in pairs(v.data.nodes) do
	  if obj:inWater(k) then
	    electrics.values['nitrous_flames_one'] = 0
	    electrics.values['nitrous_flames_two'] = 0
	    return 
	  end
	end

	--HANDLE NITROUS OXIDE FIRE EFFECT--

	--this should prevent errors when you don't have nitrous oxide installed
	if not electrics.values["nitrousOxideActive"] then return end
	
	--this should prevent errors if you somehow have no engine but still have nitrous
	if not electrics.values["engineRunning"] then return end
	
    local nitrous_flames_one = 0
	local nitrous_flames_two = 0

	if electrics.values["nitrousOxideActive"] == 1 and electrics.values["engineRunning"] == 1 then
		nitrousfiretime = nitrousfiretime + dt
		if nitrousfiretime > 0.05 then
			nitrousfiretime = 0
			nitrousfirecooldown = 0.05
		end
		if nitrousfirecooldown > 0 then
			nitrousfiretime = 0
			nitrousfirecooldown = nitrousfirecooldown - dt
			nitrous_flames_one = 0
			nitrous_flames_two = 1
		else
			nitrousfirecooldown = 0
			nitrous_flames_one = 1
			nitrous_flames_two = 0
		end
	end	
	
    electrics.values['nitrous_flames_one'] = nitrous_flames_one
	electrics.values['nitrous_flames_two'] = nitrous_flames_two
end


-- public interface
M.enableFire  = enableFire
M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M