local M = {}

local function init()
   electrics.values.MDdrls_R = 0
   electrics.values.MDdrls_L = 0
end

local function reset()
   init()
end

local function updateGFX(dt)
   if electrics.values.ignitionLevel == 2 then
      if electrics.values.signal_right_input == 1 then
         electrics.values.MDdrls_R = 0 -- turn off DRLs in park mode
      else
         electrics.values.MDdrls_R = 1 -- turn on DRLs in other modes
      end

      if electrics.values.signal_left_input == 1 then
         electrics.values.MDdrls_L = 0 -- turn off DRLs in park mode
      else
         electrics.values.MDdrls_L = 1 -- turn on DRLs in other modes
      end
   else
      electrics.values.MDdrls_R = 0 -- turn off DRLs when ignition is off
      electrics.values.MDdrls_L = 0 -- turn off DRLs when ignition is off
   end
end

M.onInit = init
M.onReset = init
M.updateGFX = updateGFX

return M
