--This LUA Script has been produced by Phaien.
--Using this code for your own mod is allowed as long as Credits to my name, "Phaien", are given.

local M = {}
M.type = "auxiliary"

local engine = nil
local electricsName = nil
local hasBuiltPie = false

local rpmToAV = 0.104719755

local tempRevLimiterAV = 0
local tempRevLimiterRPM = 0
local twoStepState = "deactivated"

-- Der Wert, der den Launch Control Status aktiviert/deaktiviert
local activeLaunchControl = false

-- Schwellenwert für die Radgeschwindigkeit in m/s (3 km/h entspricht etwa 0.833 m/s)
local speedThreshold = 3 / 3.6 -- Umrechnung von km/h in m/s

-- Variable, die den Zustand des Menüs "toggleTwoStep" verfolgt
local menuTwoStepActive = false

local function displayState()
  -- Wir verzichten auf diese Ausgabe, da keine Debugging-Informationen gewünscht sind
end

local function setTwoStep(enabled)
  if engine then
    if enabled then
      twoStepState = "idle"
    else
      twoStepState = "deactivated"
      engine:resetTempRevLimiter()  -- Reset des TempRevLimiters, wenn deaktiviert
    end
    -- Wenn twoStep aktiviert ist, setze activeLaunchControl auf true
    electrics.values.activeLaunchControl = menuTwoStepActive and (electrics.values.throttle >= 0.7 and electrics.values.brake >= 0.7)
    
    -- Wenn activeLaunchControl deaktiviert ist, auch den TempRevLimiter zurücksetzen
    if not electrics.values.activeLaunchControl then
      engine:resetTempRevLimiter()
    end
  end
end

local function toggleTwoStep()
  if engine then
    setTwoStep(twoStepState == "deactivated")
    -- Toggle den Menü-Status für "TwoStep"
    menuTwoStepActive = not menuTwoStepActive
  end
end

local function setTwoStepRPM(rpm)
  tempRevLimiterRPM = rpm
  tempRevLimiterAV = tempRevLimiterRPM * rpmToAV
  
  -- Wenn Launch Control aktiviert ist, setzen wir den TempRevLimiter-Wert
  if electrics.values.activeLaunchControl then
    engine:setTempRevLimiter(tempRevLimiterAV)
  else
    engine:resetTempRevLimiter()  -- Wenn Launch Control deaktiviert ist, resetten wir den TempRevLimiter
  end
end

local function changeTwoStepRPM(amount)
  setTwoStepRPM(tempRevLimiterRPM + amount)
end

local function updateGFX(dt)
  -- Überprüfen der Radgeschwindigkeit und Deaktivierung der Launch Control, wenn Geschwindigkeit > 3 km/h
  if electrics.values.wheelspeed >= speedThreshold then
    electrics.values.activeLaunchControl = false
    engine:resetTempRevLimiter()  -- Deaktivierung des TempRevLimiters
  else
    if twoStepState == "idle" then
      local usesKeyboard = input.state.throttle.filter == FILTER_KBD or input.state.throttle.filter == FILTER_KBD2
      local isSpeedLowEnough = usesKeyboard and (electrics.values.wheelspeed <= 2) or (electrics.values.wheelspeed <= 0.5)
      local isThrottleHighEnough = usesKeyboard and (electrics.values.throttle >= 0.2) or (electrics.values.throttle >= 0.8)
      local isBrakeHighEnough = usesKeyboard and (electrics.values.brake >= 0.2) or (electrics.values.brake >= 0.8)

      if isSpeedLowEnough and isThrottleHighEnough and isBrakeHighEnough then
        twoStepState = "armed"
      end
    elseif twoStepState == "armed" then
      engine:setTempRevLimiter(tempRevLimiterAV)

      if electrics.values.brake <= 0 or electrics.values.throttle <= 0 then
        engine:resetTempRevLimiter()
        twoStepState = "idle"
      end
    end

    -- Wenn die Radgeschwindigkeit unter dem Schwellenwert liegt und Launch Control aktiv ist,
    -- wird der TempRevLimiter wieder gesetzt
    if electrics.values.wheelspeed < speedThreshold and electrics.values.activeLaunchControl then
      engine:setTempRevLimiter(tempRevLimiterAV)  -- Wieder aktivieren des TempRevLimiters
    end

    -- Den Wert für activeLaunchControl setzen, wenn throttle und brake beide >= 0.7
    electrics.values.activeLaunchControl = menuTwoStepActive and (electrics.values.throttle >= 0.7 and electrics.values.brake >= 0.7)

    -- Wenn activeLaunchControl deaktiviert ist, auch den TempRevLimiter zurücksetzen
    if not electrics.values.activeLaunchControl then
      engine:resetTempRevLimiter()
    end
  end
end

local function reset()
  if engine then
    engine:resetTempRevLimiter()
  end
  if twoStepState ~= "deactivated" then
    twoStepState = "idle"
  end
end

local function init(jbeamData)
  local engineName = jbeamData.engineName or "mainEngine"
  electricsName = jbeamData.electricsName or "twoStep"
  engine = powertrain.getDevice(engineName)
  M.updateGFX = engine and updateGFX or nop
  twoStepState = "deactivated"

  setTwoStepRPM(jbeamData.rpmLimit or 2000)

  if not hasBuiltPie then
    if engine then
      core_quickAccess.addEntry(
        {
          level = "/powertrain/",
          generator = function(entries)
            table.insert(entries, {title = "Two-Step", priority = 40, ["goto"] = "/powertrain/twoStep/", icon = "radial_flee"})
          end
        }
      )

      core_quickAccess.addEntry(
        {
          level = "/powertrain/twoStep",
          generator = function(entries)
            local enableEntry = {
              title = "Toggle",
              priority = 30,
              icon = "radial_toggle",
              onSelect = function()
                controller.getController("twoStepLaunch").toggleTwoStep()
                return {"reload"}
              end
            }
            if twoStepState ~= "deactivated" then
              enableEntry.color = "#ff6600"
            end
            local upEntry = {
              title = "RPM Up",
              priority = 10,
              icon = "material_keyboard_arrow_up",
              onSelect = function()
                controller.getController("twoStepLaunch").changeTwoStepRPM(100)
                return {"reload"}
              end
            }
            local downEntry = {
              title = "RPM Down",
              priority = 20,
              icon = "material_keyboard_arrow_down",
              onSelect = function()
                controller.getController("twoStepLaunch").changeTwoStepRPM(-100)
                return {"reload"}
              end
            }
            table.insert(entries, enableEntry)
            table.insert(entries, upEntry)
            table.insert(entries, downEntry)
          end
        }
      )
    end
    hasBuiltPie = true
  end
end

local function serialize()
  return {
    state = twoStepState,
    rpm = tempRevLimiterRPM
  }
end

local function deserialize(data)
  if data and data.state and data.rpm then
    twoStepState = data.state
    setTwoStepRPM(data.rpm)
  end
end

local function setParameters(parameters)
  if parameters.isEnabled ~= nil then
    setTwoStep(parameters.isEnabled)
  end
  if parameters.launchRPM then
    setTwoStepRPM(parameters.launchRPM)
  end
end

M.init = init
M.reset = reset
M.updateGFX = nop
M.setTwoStep = setTwoStep
M.toggleTwoStep = toggleTwoStep
M.changeTwoStepRPM = changeTwoStepRPM
M.serialize = serialize
M.deserialize = deserialize

M.setParameters = setParameters

return M
