local M = {}
local gearbox = nil
local isBumping = false
local bumpDuration = 0.05
local lastDeltaTime = 0

local function init(jbeamData)
  local gearboxName = jbeamData.gearboxName or "gearbox"
  gearbox = powertrain.getDevice(gearboxName)
  bumpDuration = jbeamData.time or 0.05
end

local function setTransbrake(value)
  if gearbox then
    gearbox:setLock(value)
  end
end

local function updateGFX(dt)
  if isBumping then
    setTransbrake(false)
    lastDeltaTime = lastDeltaTime + dt
    if lastDeltaTime > bumpDuration then
      isBumping = false
      lastDeltaTime = 0
      setTransbrake(true)
    end
  end
end

local function bump()
  if gearbox.lockCoef == 0 then
    isBumping = true
  end
end

-- public interface
M.init = init
M.updateGFX = updateGFX
M.bump = bump

return M
