-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['rearbag'] = 0
  electrics.values['rearbag_input'] = 0
  electrics.values['frontbag'] = 0
  electrics.values['frontbag_input'] = 0
end

local function updateGFX(dt) -- ms
  electrics.values['rearbag'] = math.min(1, math.max(-0.0, (electrics.values['rearbag'] + electrics.values['rearbag_input'] * dt * 1.25)))
  electrics.values['frontbag'] = math.min(1, math.max(-0.0, (electrics.values['frontbag'] + electrics.values['frontbag_input'] * dt * 1.25)))
end

local function extendRearbag(value)
  electrics.values.rearbag_input = value
end

local function extendFrontbag(value)
  electrics.values.frontbag_input = value
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.extendRearbag = extendRearbag
M.extendFrontbag = extendFrontbag

return M
