-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}


local function onReset()
	
    electrics.values['crane_rotate'] = 0
    electrics.values['crane_rotate_input'] = 0
	electrics.values['crane_lift'] = 0
    electrics.values['crane_lift_input'] = 0
	electrics.values['crane_extend'] = 0
    electrics.values['crane_extend_input'] = 0
	electrics.values['crane_hook'] = 0
    electrics.values['crane_hook_input'] = 0
	electrics.values['cranesupport'] = 0
    electrics.values['cranesupport_input'] = 0
	
	electrics.values['push_cranesupport'] = 0
	electrics.values['unfold_cranesupport'] = 0
	
	electrics.values['turn_on'] = 0
    electrics.values.unload = 0
    electrics.values.unload2 = 0

end

local function updateGFX(dt)
    
	electrics.values['crane_lift'] = math.min(1, math.max(-0.0, (electrics.values['crane_lift'] + electrics.values['crane_lift_input'] * dt * 0.5* (0.5 - 0.4 * electrics.values['crane_extend']))))
	electrics.values['crane_extend'] = math.min(1, math.max(-0.0, (electrics.values['crane_extend'] + electrics.values['crane_extend_input'] * dt * 0.5)))
	electrics.values['crane_hook'] = math.min(1, math.max(-0.0, (electrics.values['crane_hook'] + electrics.values['crane_hook_input'] * dt * 0.5* (0.5 - 0.4 * electrics.values['crane_extend']))))
	electrics.values['crane_rotate'] = math.min(1, math.max(-0.5, (electrics.values['crane_rotate'] + electrics.values['crane_rotate_input'] * dt * 0.3 * (1 - 0.7 * electrics.values['crane_extend']))))
	electrics.values['cranesupport'] = math.min(1, math.max(-0.0, (electrics.values['cranesupport'] + electrics.values['cranesupport_input'] * dt )))
    

	if electrics.values['unload'] == 1 then
		electrics.values['mixer'] = 0
		electrics.values['mixer_reverse'] = electrics.values['turn_on']

				
		else
		electrics.values['mixer'] = electrics.values['turn_on']
		electrics.values['mixer_reverse'] = 0

	end



end


-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
