local M = {}
M.type = "auxilliary"

local tickIndex = 1
local tickDelay = 0.1
local timer = 0

local startDelay = 0.5
local startDelayTimer = 0
local ignitionWasActive = false
local startedTickSequence = false
local ResetActive = false

local function resetTicks()
  for i = 1, 11 do
    electrics.values["tick" .. i] = 0
  end
  tickIndex = 1
  timer = 0
  startDelayTimer = 0
  startedTickSequence = false
end

function M.onReset()
  resetTicks()
  ignitionWasActive = false
  ResetActive = true
end

function M.updateGFX(dt)
  local ignition = electrics.values.ignitionLevel or 0
  if ResetActive then
    electrics.values.resetcar = 1
    ResetActive = false
  else 
    electrics.values.resetcar = 0
  end 
  if ignition ~= 0 then
    if not ignitionWasActive then
      resetTicks()
      ignitionWasActive = true
    end
    if not startedTickSequence then
      startDelayTimer = startDelayTimer + dt
      if startDelayTimer >= startDelay then
        startedTickSequence = true
        electrics.values.runcar = 1
      end
    else
      if tickIndex <= 11 then
        timer = timer + dt
        if timer >= tickDelay then
          electrics.values["tick" .. tickIndex] = 1
          tickIndex = tickIndex + 1
          timer = 0
        end
      else
        electrics.values.runcar = 2
      end
    end

  else
    if ignitionWasActive or startedTickSequence then
      resetTicks()
      ignitionWasActive = false
    end
    electrics.values.runcar = 0
  end
end

return M