
const numbersContainer = document.querySelector('.numbers');
const linesContainer = document.querySelector('.lines');
const needleWrapper = document.querySelector('.speed-needle-wrapper');
const dangerZone = document.querySelector('.rpm-danger-zone');
const centerX = 250;
const centerY = 250;
let radius = 217;

let startAngle = 180;
let endAngle = 30;
let gaugeDrawn = false;
let currentMode = null;
needleWrapper.addEventListener('animationend', () => {
  if (!gaugeDrawn) {
    animateNumbersAndTicks();
    gaugeDrawn = true;
    currentMode = "INITIAL";
  }
});
function animateNumbersAndTicks() {
  const centerX = 250;
  const centerY = 250;
  const totalNumbers = 11;
  const numberssec = 100;
  
  setTimeout(() => {
    document.querySelector('.Bigdiv')?.classList.add('gradient-on');
  }, 500);

  for (let i = 0; i < totalNumbers; i++) {
    const fraction = i / (totalNumbers - 1);
    const angleDeg = startAngle + fraction * (endAngle - startAngle);
    const angleRad = angleDeg * Math.PI / 90;
    const y = centerX + radius * Math.cos(angleRad);
    const x = centerY + radius * Math.sin(angleRad);

    const span = document.createElement('span');
    span.textContent = i.toString();
    span.style.left = `${x + -5}px`;
    span.style.top = `${y +  -5}px`;
    span.style.transform = 'translate(-50%, -50%)';
    span.classList.add('number');
    span.style.opacity = '0';
    span.style.fontSize = '30px';
    numbersContainer.appendChild(span);

    setTimeout(() => {
      span.style.opacity = '1';
    }, i * numberssec);
  }

  setTimeout(() => {
    dangerZone.style.opacity = '1';
  
    const targetAngle = 148;
    dangerZone.style.transform = `rotate(${targetAngle}deg)`;
  }, 7.5);
  customTicks.forEach((tickData, i) => {
    const angleRad = tickData.angle * Math.PI / 180;
    const adjustedRadius = radius;
    const innerX = centerX + (adjustedRadius - tickData.innerOffset) * Math.cos(angleRad);
    const innerY = centerY + (adjustedRadius - tickData.innerOffset) * Math.sin(angleRad);

    const tick = document.createElement('div');
    tick.style.position = 'absolute';
    tick.style.left = `${innerX - 5}px`;
    tick.style.top = `${innerY}px`;
    tick.style.width = `${tickData.width}px`;
    tick.style.height = `${tickData.length}px`;
    tick.style.background = tickData.color;
    tick.style.transform = `rotate(${tickData.angle}deg) translate(-50%, -50%)`;
    tick.style.transformOrigin = 'top center';
    tick.style.opacity = '0';

    linesContainer.appendChild(tick);

    setTimeout(() => {
      tick.style.opacity = '1';
    }, i * numberssec);
  });
  customTicks2.forEach((tickData, i) => {
    const angleRad = tickData.angle * Math.PI / 180;
    const adjustedRadius = tickData.radius ?? radius;
    const innerX = centerX + (adjustedRadius - tickData.innerOffset) * Math.cos(angleRad);
    const innerY = centerY + (adjustedRadius - tickData.innerOffset) * Math.sin(angleRad);
  
    const tick = document.createElement('div');
    tick.style.position = 'absolute';
    tick.style.left = `${innerX - 8}px`;
    tick.style.top = `${innerY - 5}px`;
    tick.style.width = `${tickData.width}px`;
    tick.style.height = `${tickData.length}px`;
    tick.style.background = tickData.color;
    tick.style.transform = `rotate(${tickData.angle}deg) translate(-50%, -50%)`;
    tick.style.transformOrigin = 'top center';
    tick.style.opacity = '0';
    linesContainer.appendChild(tick);
  
    setTimeout(() => {
      tick.style.opacity = '1';
    }, i * numberssec);
  });
  const dotCount = 100;
  const dotRadius = 249;
  const dotSize = 4;

  for (let i = 0; i < dotCount; i++) {
    const angleDeg = (360 / dotCount) * i;
    const angleRad = angleDeg * Math.PI / 180;
    const x = centerX + dotRadius * Math.cos(angleRad);
    const y = centerY + dotRadius * Math.sin(angleRad);
    const dot = document.createElement('div');
    dot.style.position = 'absolute';
    dot.style.width = `${dotSize}px`;
    dot.style.height = `${dotSize}px`;
    dot.style.backgroundColor = '#354964';
    dot.style.borderRadius = '50%';
    dot.style.left = `${x - dotSize / 2 - 5}px`;
    dot.style.top = `${y - dotSize / 2 - 5}px`;
    dot.style.opacity = '0';

    linesContainer.appendChild(dot);

    setTimeout(() => {
      dot.style.opacity = '1';
    }, i * 8.5);
  }
}

const customTicks = [
  { angle: 105, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 135, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 165, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 195, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 225, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 255, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 285, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 315, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 345, color: 'black', length: 2, width: 6, innerOffset: 0 },
  { angle: 375, color: 'black', length: 2, width: 6, innerOffset: 0 },
];
const customTicks2 = [
  { angle: 90, color:   '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 118.7, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 147.6, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 180.5, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 208.7, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 237.7, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 270, color:   '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 302.5, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 331.2, color: '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 360, color:   '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
 { angle: 389, color:   '#354964', length: 5, width: 6, innerOffset: 0, radius: 252 },
];

const gearsMap = ['P', 'R', 'N', 'D', 'S', 'M'];

function updateGearSlide(gearValue, gearLabel = '') {
  const gearElements = {
    'P': document.querySelector('.gear-p'),
    'R': document.querySelector('.gear-r'),
    'N': document.querySelector('.gear-n'),
    'D': document.querySelector('.gear-d'),
    'S1': document.querySelector('.gear-s1'),
    'M': document.querySelector('.gear-m')
  };

  const gearsMap = ['P', 'R', 'N', 'D', 'S1', 'M'];
  const currentGear = gearsMap[gearValue];
  const prevGear = gearsMap[(gearValue - 1 + gearsMap.length) % gearsMap.length];
  const nextGear = gearsMap[(gearValue + 1) % gearsMap.length];

  if (currentGear === 'M' && gearLabel) {
    gearElements['M'].textContent = gearLabel;
  }

  for (let gear in gearElements) {
    const el = gearElements[gear];
    el.classList.remove('active', 'prev', 'next', 'hidden');

    if (gear === currentGear) {
      el.classList.add('active');
    } else if (gear === prevGear) {
      el.classList.add('prev');
    } else if (gear === nextGear) {
      el.classList.add('next');
    } else {
      el.classList.add('hidden');
    }
  }
}
updateGearSlide(0);

let maxValue_NORMAL = 10000;
let startAngle_NORMAL = 0;
let endAngle_NORMAL = 298;

let maxValue_SPORT = 11500;
let startAngle_SPORT = 0;
let endAngle_SPORT = 266.67;

function setNeedleAngle(value) {
  let startAngleLocal, endAngleLocal, maxValue;

  if (currentMode === 'SPORT') {
    startAngleLocal = startAngle_SPORT;
    endAngleLocal = endAngle_SPORT;
    maxValue = maxValue_SPORT;
  } else {
    startAngleLocal = startAngle_NORMAL;
    endAngleLocal = endAngle_NORMAL;
    maxValue = maxValue_NORMAL;
  }

  const fraction = Math.min(value, maxValue) / maxValue;
  const angle = startAngleLocal + fraction * (endAngleLocal - startAngleLocal);

  const needle = document.getElementById('speedNeedle');
  if (needle) {
    needle.style.transform = `rotate(${angle}deg)`;
  }
}
setTimeout(() => {
  setNeedleAngle(0);
}, 1000);

//side


angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  $scope.data = {};

  var units = {
    uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  $window.updateData = function(data) {
    $scope.$evalAsync(() => {
      const gear = data.electrics.gear;
      const modeMLabel = document.getElementById('m-mode');   
      const modeSLabel = document.getElementById('s-mode');   
      const fuelLevel = Math.max(0, Math.min(1, parseFloat(data?.electrics?.fuel) || 0)); 
      const tempValue = Math.max(0, Math.min(130, parseFloat(data?.electrics?.watertemp) || 0));
      const oilTemp = Math.max(0, Math.min(130, parseFloat(data?.electrics?.oiltemp) || 0));
      const rpm = Math.max(0, Math.min(10000, parseFloat(data?.electrics?.rpm) || 0));
      setNeedleAngle(rpm);

      $scope.data.speedVal = UiUnits.speed(data.electrics.wheelspeed).val.toFixed(0);
      $scope.data.time = data.customModules.environmentData.time;
      //gear
      if (gear === "P") {
        updateGearSlide(0);

        modeSLabel.textContent = 'S';
        modeMLabel.textContent = 'M';
      } else if (gear === "R") {
        updateGearSlide(1);
        modeSLabel.textContent = 'S';
        modeMLabel.textContent = 'M';
      } else if (gear === "N") {
        updateGearSlide(2);
        modeSLabel.textContent = 'S';
        modeMLabel.textContent = 'M';
      } else if (gear === "D") {
        updateGearSlide(3);
        modeSLabel.textContent = 'S';
        modeMLabel.textContent = 'M';
      } else if (/^S[1-8]$/.test(gear)) {
        updateGearSlide(4);
        modeMLabel.textContent = 'M';
        modeSLabel.textContent = gear;
      } else if (/^M[1-8]$/.test(gear)) {
        updateGearSlide(5, gear);
        modeSLabel.textContent = 'S';
        modeMLabel.textContent = gear;
      }
      //odometer
      if (data.electrics.odometer) {
        let val = data.electrics.odometer;
        val *= (units.uiUnitLength == "metric") ? 0.001 : 0.0006215;
        val = Math.min(999999, val);
        $scope.data.odometer = val.toFixed(0) + ((units.uiUnitLength == "metric") ? "km" : "mi");
      } else {
        $scope.data.odometer = "";
      }

      let fakemilElement = document.querySelector('.fakemil div');
      if (fakemilElement) {
        fakemilElement.textContent = $scope.data.odometer;
      }
      if (data.electrics.odometer) {
        let val2 = data.electrics.odometer;
        val2 *= (units.uiUnitLength == "metric") ? 0.001 : 0.0006215;
        val2 = Math.min(999999, val2);
        $scope.data.odometer2 = val2.toFixed(1) + ((units.uiUnitLength == "metric") ? " km" : " mi");
      } else {
        $scope.data.odometer2 = "";
      }
      
      //fuel
      const maxFuelHeight = 250;
      const fuelOverlay = document.querySelector('.overlay-fuel');
      if (fuelOverlay) {
        fuelOverlay.style.height = `${fuelLevel * maxFuelHeight}px`;
        fuelOverlay.style.top = `${380 + (1 - fuelLevel) * maxFuelHeight}px`;
      }
      //temp
      const tempLevel = tempValue / 130;
      const maxTempHeight = 250;
      const baseTempTop = 80;
      const tempOverlay = document.querySelector('.overlay-temp');
      
      if (tempOverlay) {
        const newHeight = tempLevel * maxTempHeight;
        const newTop = baseTempTop + (maxTempHeight - newHeight);
      
        tempOverlay.style.height = `${newHeight}px`;
        tempOverlay.style.top = `${newTop}px`;
      }
      //oiltemp
      const oilTempLevel = oilTemp / 130;

      const maxOilHeight = 250;
      const baseOilTop = 80;
      const oilOverlay = document.querySelector('.overlay-oiltemp');
      
      if (oilOverlay) {
        const newHeight = oilTempLevel * maxOilHeight;
        const newTop = baseOilTop + (maxOilHeight - newHeight);
      
        oilOverlay.style.height = `${newHeight}px`;
        oilOverlay.style.top = `${newTop}px`;
      }
      //lowoil
      const minRPM = 800;
      const maxRPM = 10000;
      const pressureScale = rpm < minRPM ? 0 : rpm > maxRPM ? 1 : (rpm - minRPM) / (maxRPM - minRPM);
      
      const maxLowOilHeight = 250;
      const baseLowOilTop = 380;
      
      const lowOilOverlay = document.querySelector('.overlay-lowoil');
      if (lowOilOverlay) {
        const newHeight = pressureScale * maxLowOilHeight;
        const newTop = baseLowOilTop + (maxLowOilHeight - newHeight);
      
        lowOilOverlay.style.height = `${newHeight}px`;
        lowOilOverlay.style.top = `${newTop}px`;
      }
      //temperature
      let tempEnv = UiUnits.temperature(data.customModules.environmentData.temperatureEnv);
      let roundedTemp = Math.round(tempEnv.val);
      
      if (roundedTemp > 99 || roundedTemp < -99) {
        $scope.data.temp = "---°C";
      } else {
        $scope.data.temp = roundedTemp + tempEnv.unit;
      } 

      //panels
      const leftPanel = document.querySelector('.side-panel-left');
      const rightPanel = document.querySelector('.side-panel-right');
      if (data.electrics.ignitionLevel === 3 && !window.panelsOpened) {
        window.panelsOpened = true;
      
        setTimeout(() => {
          const Bigdiv = document.querySelector('.Bigdiv');
          
          if (currentMode === "SPORT") {
            document.body.classList.add('sport-mode');
            gaugeDrawn = false;
            const auto = document.querySelector('.auto');
            auto.textContent = 'SPORT';
            
          } 
          else if (currentMode === "OFF") {
            Bigdiv.style.background = 'radial-gradient(black 190px, #354964 85%)';
            const auto = document.querySelector('.auto');
            auto.textContent = 'OFF';
          } 
          else {
            Bigdiv.style.background = 'radial-gradient(black 150px, #354964 55%)';
          }
        
          leftPanel?.classList.add('open');
          rightPanel?.classList.add('open');
        }, 700);
        
      } else if (data.electrics.ignitionLevel === 0 && window.panelsOpened) {
        window.panelsOpened = false;
        leftPanel?.classList.remove('open');
        rightPanel?.classList.remove('open');
      } else if (data.electrics.ignitionLevel === 0) {
        const Biggdiv = document.querySelector('.Bigdiv');
        Biggdiv.style.background = 'black'
        leftPanel?.classList.remove('open');
        rightPanel?.classList.remove('open');
      }
      //red mask
      const rpmWarning = document.getElementById('rpmWarning');

      if (currentMode === 'SPORT' && rpm >= 9000) {
        rpmWarning.style.display = 'block';
      } else {
        rpmWarning.style.display = 'none';
      }
    });
    if (typeof window.runcarWasTriggered === 'undefined') {
      window.runcarWasTriggered = false;
    }
    if (data.electrics.runcar === 1) {
      if (!window.runcarWasTriggered) {
        window.runcarWasTriggered = true;
        const auto = document.querySelector('.auto');
        if (auto) auto.textContent = 'AUTO';
        document.body.classList.remove('sport-mode');
        gaugeDrawn = false;
        document.querySelectorAll('.numbers span, .lines div').forEach(el => el.remove());
        animateNumbersAndTicks();
    }
    } else {
      window.runcarWasTriggered = false;
    }
    //restart gauges
    const leftPanel = document.querySelector('.side-panel-left');
    const rightPanel = document.querySelector('.side-panel-right');
    if (data.electrics.resetcar === 1 ) {
      leftPanel?.classList.add('open');
      rightPanel?.classList.add('open');
      const auto = document.querySelector('.auto');
      if (currentMode === "SPORT") {
        document.body.classList.add('sport-mode');
        gaugeDrawn = false;
        document.querySelectorAll('.numbers span, .lines div').forEach(el => el.remove());
        auto.textContent = 'SPORT';
      } 
      else if (currentMode === "OFF") {
        document.body.classList.remove('sport-mode');
        document.querySelector('.Bigdiv').style.background = 'radial-gradient(black 190px, #354964 85%)';
    
        if (!gaugeDrawn) {
          animateNumbersAndTicks();
          gaugeDrawn = true;
        }
        auto.textContent = 'OFF';
    
      } else if(currentMode === "COMFORT") {
        document.body.classList.remove('sport-mode');
        document.querySelector('.Bigdiv').style.background = 'radial-gradient(black 150px, #354964 55%)';
        auto.textContent = 'AUTO';
        if (!gaugeDrawn) {
          animateNumbersAndTicks();
          gaugeDrawn = true;
        }
      }
    }


  };
  $window.updateMode = function(data) {
    const newMode = data.modeName;
    if (newMode === currentMode) return;
    currentMode = newMode;
    const auto = document.querySelector('.auto');
  

  
    if (newMode === "SPORT") {
      document.body.classList.add('sport-mode');
      gaugeDrawn = false;
      document.querySelectorAll('.numbers span, .lines div').forEach(el => el.remove());
      auto.textContent = 'SPORT';
    } 
    else if (newMode === "OFF") {
      document.body.classList.remove('sport-mode');
      document.querySelector('.Bigdiv').style.background = 'radial-gradient(black 190px, #354964 85%)';
  
      if (!gaugeDrawn) {
        animateNumbersAndTicks();
        gaugeDrawn = true;
      }
      auto.textContent = 'OFF';
  
    } else if(newMode === "COMFORT") {
      document.body.classList.remove('sport-mode');
      document.querySelector('.Bigdiv').style.background = 'radial-gradient(black 150px, #354964 55%)';
      auto.textContent = 'AUTO';
      if (!gaugeDrawn) {
        animateNumbersAndTicks();
        gaugeDrawn = true;
      }
    }
  };
});