-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onInit()
 electrics.values.lx570SpeedoLow = 0
 electrics.values.lx570SpeedoHigh = 0
 electrics.values.lx570Speedo = 0
end

local function updateGFX(dt)
electrics.values.lx570SpeedoLow = electrics.values.wheelspeed
electrics.values.lx570SpeedoHigh = 30 / 3.6 + (electrics.values.wheelspeed / 1.4)
 if electrics.values.wheelspeed < 100 / 3.6 then 
    electrics.values.lx570Speedo = electrics.values.lx570SpeedoLow  
 else
    electrics.values.lx570Speedo = electrics.values.lx570SpeedoHigh
 end	
end

-- public interface

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
