local M = {}

local audio = "test"
local soundPlayed = false

local function playSound()
    -- name, nodeId, volume, pitch
    obj:playSFXOnce(audio, 0, 1, 1)
end

local function onInit(jbeamData)
    -- path, description, name, playOnAdd
    obj:createSFXSource("/vehicles/sdd_teme/sounds/test.mp3", "AudioClosest3D", audio, -1)

    --[[ possible descriptions are:
        AudioDefault3D
        AudioSoft3D
        AudioClose3D
        AudioClosest3D
        AudioMusic3D

        AudioDefaultLoop3D
        AudioCloseLoop3D
        AudioClosestLoop3D
        AudioMusicLoop3D

        Audio2D
        AudioStream2D
        AudioMusic2D

        AudioLoop2D
        AudioStreamLoop2D
    ]]
end

local function updateGFX(dt)
    local KeyOff
    local DoorOpen
    if electrics.values.ignitionLevel < 2 then
        KeyOff = true
        print("Key Off")
    else
        KeyOff = false
        soundPlayed = false
    end
    if electrics.values.doorLCoupler_notAttached == 1 or electrics.values.doorRCoupler_notAttached == 1 then
        DoorOpen = true
        print("Door Open")
    else
        DoorOpen = false
        soundPlayed = false
    end
    
    if DoorOpen == true and KeyOff == true and soundPlayed == false then
        print("Alarm")
        playSound()
        soundPlayed = true
    end
    
end

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

M.playSound = playSound

return M