local M = {}

local rearWheelIndices = {0, 1}
local transitionSpeed = 20
local slowdownFactor = 1.43
local smoothingFactor = 0.05
local smoothedSpeed = 0

local function init()
    smoothedSpeed = 0
end

local function updateGFX(dt)
    local wheelsTable = wheels.wheels
    if not wheelsTable then return end

    local totalSpeed = 0
    local validWheels = 0

    for _, idx in ipairs(rearWheelIndices) do
        local wheel = wheelsTable[idx]
        if wheel and wheel.angularVelocity and wheel.radius then
            local linearSpeed = wheel.angularVelocity * wheel.radius
            local rawSpeed = math.abs(linearSpeed * 3.6)

            local adjustedSpeed
            if rawSpeed <= transitionSpeed then
                adjustedSpeed = rawSpeed
            else
                local excess = rawSpeed - transitionSpeed
                adjustedSpeed = transitionSpeed + (excess * slowdownFactor)
            end

            totalSpeed = totalSpeed + adjustedSpeed
            validWheels = validWheels + 1
        end
    end

    if validWheels == 0 then return end

    local averageSpeed = totalSpeed / validWheels
    smoothedSpeed = smoothedSpeed + (averageSpeed - smoothedSpeed) * smoothingFactor
    electrics.values.LXRwheelspeed = smoothedSpeed
end

M.init = init
M.updateGFX = updateGFX

return M
