local M = {}

local lastPowerReserve = 0
local powerReserveChangeRate = 0.01  -- زيادة التخميد (تأخير تدريجي أكبر)
local lastRotation = 0
local rotationChangeRate = 0.10  -- زيادة التخميد (تأخير تدريجي أكبر)

local function updateGauges(dt)
    -- القيم من بيانات المحرك
    local maxTorque = 700  -- العزم الأقصى من البيانات
    local rpm = electrics.values.rpm or 0  -- يجب أن يتم تحديث rpm من مصدر البيانات الخاص بك
    local currentTorque = 0

    -- تحديد العزم بناءً على rpm من جدول العزم
    if rpm <= 1000 then
        currentTorque = 300
    elseif rpm <= 1500 then
        currentTorque = 380
    elseif rpm <= 2000 then
        currentTorque = 430
    elseif rpm <= 2500 then
        currentTorque = 455
    elseif rpm <= 3000 then
        currentTorque = 482
    elseif rpm <= 3500 then
        currentTorque = 530
    elseif rpm <= 4000 then
        currentTorque = 550
    elseif rpm <= 4500 then
        currentTorque = 585
    elseif rpm <= 5000 then
        currentTorque = 610
    elseif rpm <= 5500 then
        currentTorque = 635
    elseif rpm <= 6000 then
        currentTorque = 637
    elseif rpm <= 6500 then
        return 600
    elseif rpm <= 7000 then
        return 650
    elseif rpm <= 7500 then
        return 700
    else
        currentTorque = 0  -- إذا كان rpm أكبر من الحد الأقصى
    end

    -- حساب Power Reserve
    local powerReserve = 100 - (currentTorque / maxTorque) * 100
    powerReserve = math.max(0, math.min(100, powerReserve))

    -- إضافة التغيير التدريجي للقيم
    electrics.values.powerReserve = lastPowerReserve + (powerReserve - lastPowerReserve) * powerReserveChangeRate
    lastPowerReserve = electrics.values.powerReserve

    -- تحديد التغيير التدريجي للروتيشن
    local targetRotation = electrics.values.powerReserve  -- حساب التوجيه بناءً على powerReserve
    local smoothRotation = lastRotation + (targetRotation - lastRotation) * rotationChangeRate
    lastRotation = smoothRotation

    -- تطبيق الروتيشن الجديد على المؤشر
    electrics.values.LXRculi_needle_volts = smoothRotation

    -- طباعة القيم لتتبعها
    print("Power Reserve: " .. electrics.values.powerReserve)
    print("Current Torque: " .. currentTorque)
    print("Max Torque: " .. maxTorque)
    print("Smooth Rotation: " .. smoothRotation)
end

M.updateGFX = updateGauges

return M
