--[[
  Speed Warning Script
  Made by: flanje
  Usage: This script may only be used if you have permission from flanje.
         This Lua is studied by AI and made with help of AI.
]]

local M = {}

local CHIME_NODE = "dsh3"
local CHIME_PATH = "/art/sound/stinger_chime.mp3"
local SPEED_THRESHOLD = 120 / 3.6  -- convert km/h to m/s

local hasPlayed = false
local current_sfx_sources = {}

local function cleanupSounds()
  for _, sfx in ipairs(current_sfx_sources) do
    if sfx then
      obj:stopSFX(sfx)
      obj:deleteSFXSource(sfx)
    end
  end
  current_sfx_sources = {}
end

local function playChimeOnce()
  local v = _G.v
  if not v or not v.data or not v.data.nodes then return end

  local nodeId = 0
  for _, node in ipairs(v.data.nodes) do
    if node.name == CHIME_NODE then
      nodeId = node.cid
      break
    end
  end
  if nodeId == 0 then return end

  local src = obj:createSFXSource(CHIME_PATH, "AudioDefault3D", "speedChime_"..nodeId, nodeId)
  if src then
    obj:setVolumePitch(src, 4.0, 1.0)  -- volume doubled, pitch unchanged
    obj:playSFX(src)
    table.insert(current_sfx_sources, src)
  end
end

local function updateGFX(dt)
  if not electrics or not electrics.values then return end

  local speed = electrics.values.wheelspeed or 0

  if speed > SPEED_THRESHOLD then
    if not hasPlayed then
      playChimeOnce()
      hasPlayed = true
    end
  else
    -- reset once speed drops back below threshold
    hasPlayed = false
  end
end

local function reset()
  cleanupSounds()
  hasPlayed = false
end

M.updateGFX = updateGFX
M.onReset = reset
M.onInit = reset
M.onVehicleActiveChanged = function(active) if not active then cleanupSounds() end end
M.destroy = cleanupSounds

return M
