--[[
  Door Chime Script
  Made by: flanje
  Usage: This script may only be used if you have permission from flanje.
         This Lua is studied by AI and made with help of AI.
]]

local M = {}

local CHIME_NODE = "dsh3"
local CHIME_PATH = "/art/sound/stinger_chime.mp3"
local CHIME_INTERVAL = 1.5      -- normal repeat
local CHIME_INTERVAL_FAST = 0.8 -- faster repeat when lights are on

local chimeTimer = 0
local lastChimeCondition = false
local current_sfx_sources = {}

local function cleanupSounds()
  for _, sfx in ipairs(current_sfx_sources) do
    if sfx then
      obj:stopSFX(sfx)
      obj:deleteSFXSource(sfx)
    end
  end
  current_sfx_sources = {}
end

local function playChimeOnce()
  local v = _G.v
  if not v or not v.data or not v.data.nodes then return end

  local nodeId = 0
  for _, node in ipairs(v.data.nodes) do
    if node.name == CHIME_NODE then
      nodeId = node.cid
      break
    end
  end
  if nodeId == 0 then return end

  local src = obj:createSFXSource(CHIME_PATH, "AudioDefault3D", "doorChime_"..nodeId, nodeId)
  if src then
    obj:setVolumePitch(src, 1.0, 1.0)
    obj:playSFX(src)
    table.insert(current_sfx_sources, src)
  end
end

local function updateGFX(dt)
  if not electrics or not electrics.values then return end

  -- Door states
  local doorFL = electrics.values.doorFLCoupler_notAttached == 1
  local doorFR = electrics.values.doorFRCoupler_notAttached == 1
  local doorRL = electrics.values.doorRLCoupler_notAttached == 1
  local doorRR = electrics.values.doorRRCoupler_notAttached == 1

  -- Lights state (low/high beam)
  local lightsOn = (electrics.values.lowbeam == 1) or (electrics.values.highbeam == 1)

  local shouldChime = doorFL or doorFR or doorRL or doorRR
  local interval = lightsOn and CHIME_INTERVAL_FAST or CHIME_INTERVAL

  if shouldChime then
    if not lastChimeCondition then
      playChimeOnce()
      chimeTimer = 0
    else
      chimeTimer = chimeTimer + dt
      if chimeTimer >= interval then
        playChimeOnce()
        chimeTimer = 0
      end
    end
  else
    chimeTimer = 0
    cleanupSounds()
  end

  lastChimeCondition = shouldChime
end

local function reset()
  chimeTimer = 0
  cleanupSounds()
  lastChimeCondition = false
end

M.updateGFX = updateGFX
M.onReset = reset
M.onInit = reset
M.onVehicleActiveChanged = function(active) if not active then cleanupSounds() end end
M.destroy = cleanupSounds

return M
