local M = {}

local controllers = {}
local camPos, vehPos, camDistToCar, isInCar = nil, nil, nil, nil
M.isInCar = false

M.otherVehSensors = {
    sensors = {},
    directions = {},
    velocities = {},
    objects = {},
    idSlotMatch = {}
}

local curSlot = 1

local function checkCamInside()
    vehPos = obj:getPosition() + obj:getNodePosition((beamstate.nodeNameMap and beamstate.nodeNameMap["driver"]) or 0)
    camPos = obj:getCameraPosition()
    if camPos then
        camDistToCar = camPos:distance(vehPos)
        isInCar = camDistToCar <= 0.6
        M.isInCar = isInCar
    end
end

local function prepareSlots()
    M.otherVehSensors.idSlotMatch = {}
    M.otherVehSensors.objects = {}
    local slotCount = BeamEngine:getSlotCount()
    for i = 1, slotCount do
        local slot = BeamEngine:getSlot(i - 1)
        local id = slot:getId()
        M.otherVehSensors.idSlotMatch[i] = id
        M.otherVehSensors.objects[id] = slot
    end
    curSlot = slotCount
end

local function updateSensors(dt)
    local idList = M.otherVehSensors.idSlotMatch
    local objList = M.otherVehSensors.objects
    local curVeh = objList[idList[curSlot - 1]]

    if curVeh then
        local id = curVeh:getId()
        local sensors = M.otherVehSensors.sensors[id]
        if not sensors then
            sensors = {
                gx_smooth2 = newTemporalSmoothingNonLinear(7),
                gy_smooth2 = newTemporalSmoothingNonLinear(7),
                gz_smooth2 = newTemporalSmoothingNonLinear(7),
                sensors = {}
            }
            M.otherVehSensors.sensors[id] = sensors
        end

        local raw = sensors.sensors
        raw.gx2 = sensors.gx_smooth2:get(obj:getSensorX(), dt)
        raw.gy2 = sensors.gy_smooth2:get(obj:getSensorY(), dt)
        raw.gz2 = sensors.gz_smooth2:get(obj:getSensorZnonInertial(), dt)

        M.otherVehSensors.directions[id] = curVeh:getDirectionVector()
        M.otherVehSensors.velocities[id] = curVeh:getVelocity()
    end

    curSlot = curSlot - 1
    if curSlot <= 0 then
        prepareSlots()
    end
end

local function updateGFX(dt)
    if not playerInfo.anyPlayerSeated or electrics.values.ignitionLevel == 0 then return end

    checkCamInside()
    local mailboxData = lpack.decode(obj:getLastMailbox("systemelectricsvectoringcctsm"))
    if not (mailboxData and next(mailboxData)) then return end

    updateSensors(dt)
    for i = 1, #controllers do
        controllers[i].systemelectricsvectoringUpdate(dt, mailboxData)
    end
end

local function initSecondStage(jbeamData)
    obj:queueGameEngineLua(([[
        extensions.load("systemelectrics_nmg_stingerraycastmonitoring");
        systemelectrics_nmg_stingerraycastmonitoring.registerVehicle(%d)
    ]]):format(objectId))

    local compData = tableFromHeaderTable(jbeamData.components)
    for i = 1, #compData do
        local controllerData = compData[i]
        controllers[#controllers + 1] = controller.getController(controllerData.name)
    end
end

M.updateGFX = updateGFX
M.reset = nop
M.init = nop
M.initSecondStage = initSecondStage

return M
