local M = {}

local blindSpotTimer, blindSpotData, blindSpotEnabled = 0, {}, true
M.blindSpotRightTriggered, M.blindSpotLeftTriggered = false, false

local function getSidePoints(prefixes, nodeMap)
    local function mid(a, b)
        return (a + b) * 0.5
    end

    local left1  = obj:getNodePosition(nodeMap[prefixes[1].."l"])
    local right1 = obj:getNodePosition(nodeMap[prefixes[1].."r"])
    local left2, right2

    if #prefixes == 3 then
        left2  = mid(obj:getNodePosition(nodeMap[prefixes[2].."l"]), obj:getNodePosition(nodeMap[prefixes[3].."l"]))
        right2 = mid(obj:getNodePosition(nodeMap[prefixes[2].."r"]), obj:getNodePosition(nodeMap[prefixes[3].."r"]))
    else
        left2  = obj:getNodePosition(nodeMap[prefixes[2].."l"])
        right2 = obj:getNodePosition(nodeMap[prefixes[2].."r"])
    end

    return {
        leftOrigin = left1,
        rightOrigin = right1,
        leftDir = (vec3(left2 - left1)):normalized(),
        rightDir = (vec3(right2 - right1)):normalized()
    }
end

local function checkIntersection(origin, direction, vehPos, data)
    local hit = ({intersectsRay_OBB(vehPos + origin, direction, data.center, data.x, data.y2, data.z)})[1]
    return hit and hit > 1 and hit < 10
end

local function systemelectricsvectoringUpdate(dt, mailboxData)
    if not blindSpotEnabled then return end

    blindSpotTimer = blindSpotTimer + dt
    if blindSpotTimer <= 0.15 then return end

    local nodeMap = beamstate.nodeNameMap
    local vehPos = obj:getPosition()
    local prefixes = blindSpotData.nodePrefixes
    local p = getSidePoints(prefixes, nodeMap)

    local rightTriggered, leftTriggered = false, false
    local selfId = obj:getId()

    for id, data in pairs(mailboxData) do
        if id ~= selfId then
            if checkIntersection(p.rightOrigin, p.rightDir, vehPos, data) then rightTriggered = true end
            if checkIntersection(p.leftOrigin,  p.leftDir,  vehPos, data) then leftTriggered  = true end
        end
    end

    M.blindSpotRightTriggered = rightTriggered
    M.blindSpotLeftTriggered  = leftTriggered
    electrics.values.rightBlindSpotTriggered = rightTriggered
    electrics.values.leftBlindSpotTriggered  = leftTriggered

    blindSpotTimer = 0
end

local function init(jbeamData)
    blindSpotData = jbeamData or {}
    local nodeMap = beamstate.nodeNameMap

    for _, prefix in ipairs(blindSpotData.nodePrefixes or {}) do
        if not (nodeMap[prefix.."r"] and nodeMap[prefix.."l"]) then
            blindSpotEnabled = false
            log("D", "systemelectricsvectoring.blindSpotInit", "Node prefix missing, initialization cancelled")
            break
        end
    end

    electrics.values.rightBlindSpotTriggered = false
    electrics.values.leftBlindSpotTriggered  = false
end

M.systemelectricsvectoringUpdate = systemelectricsvectoringUpdate
M.init = init

return M
