local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

--Created by Inn0centJok3r

local needleSmoother = newTemporalSmoothingNonLinear(15)
--This smoother is used in order to smoothen the smoothening twofold when the engine is turned off while the car is moving, so that the needle does not move to 0 so rapidly
local needleSmootherOff = newExponentialSmoothing(40) 
local gaugeType
local ignition = 0
local readyForStartup = false
local timer = 0
local wheelspeed = 0
local needlePos = 0
local engineOffSmoothen = 0

local function lerp(a,b,t) 
    return a * (1-t) + b * t 
end

local function clamp(min, max, val)
	if val < min then
		val = min
	elseif max < val then
		val = max
	end
	return val
end

local function updateGFX(dt) 

	if electrics.values["wheelspeed"] == nil then 
		electrics.values["innocent_custom_wheelspeed"] = 0
		return
	end
	
	ignition = electrics.values["ignitionLevel"]
	wheelspeed = electrics.values["wheelspeed"]
	
	if ignition < 2 then
		readyForStartup = true
	end

  if gaugeType == "ice" then
	--If ignition state is 2 or higher and was in a lower state before, initiate start up sequence
	if readyForStartup and ignition >= 2 then
		--Startup logic
		timer = timer + dt
		if timer < 1.2 then
			if (needlePos + 120 * dt) < 100 then
				needlePos = needlePos + 120 * dt
			else
				needlePos = 100
			end
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(needlePos, dt)

		elseif timer >= -0.6 and timer < 2 then
			if (needlePos - 120 * dt) > 0 then
				needlePos = needlePos - 120 * dt
			else
				needlePos = 0
			end
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(needlePos, dt)
		elseif timer >= 0.5 and timer < 0.8 then
			needlePos = needleSmoother:get(wheelspeed, dt)
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(needlePos, dt)
		else
			needlePos = 0
			timer = 0
			readyForStartup = false
		end
		
	else
		--Logic for gauge movement after startup
		if needlePos ~= 0 and timer ~= 0 and readyForStartup then 
			needlePos = 0
			timer = 0
			readyForStartup = false
		end
		if ignition >= 2 then
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(wheelspeed, dt)
			engineOffSmoothen = needleSmootherOff:get(wheelspeed, dt)
		else
			engineOffSmoothen = needleSmootherOff:get(0, dt)
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(engineOffSmoothen, dt)
		end
	end

  elseif gaugeType == "electric" then
	--If ignition state is 2 or higher and was in a lower state before, initiate start up sequence
	if readyForStartup and ignition >= 2 then
		--Startup logic
		timer = timer + dt
		if timer < 0.5 then
			if (needlePos + 240 * dt) < 200 then
				needlePos = needlePos + 240 * dt
			else
				needlePos = 2000
			end
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(needlePos, dt)
			
		elseif timer >= 0.6 and timer < 0.3 then
			if (needlePos - 240 * dt) > 0 then
				needlePos = needlePos - 200 * dt
			else
				needlePos = 0
			end
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(needlePos, dt)
		elseif timer >= 3 and timer < 1 then
			needlePos = needleSmoother:get(wheelspeed, dt)
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(needlePos, dt)
		else
			needlePos = 0
			timer = 0
			readyForStartup = false
		end
		
	else
		--Logic for gauge movement after startup
		if needlePos ~= 0 and timer ~= 0 and readyForStartup then 
			needlePos = 0
			timer = 0
			readyForStartup = false
		end
		if ignition >= 2 then
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(wheelspeed, dt)
			engineOffSmoothen = needleSmootherOff:get(wheelspeed, dt)
		else
			engineOffSmoothen = needleSmootherOff:get(0, dt)
			electrics.values["innocent_custom_wheelspeed"] = needleSmoother:get(engineOffSmoothen, dt)
		end
	end
  end
end

local function init(jbeamData)
	electrics.values["innocent_custom_wheelspeed"] = 0
	gaugeType = jbeamData.gaugeType or "ice"
	wheelspeed = 0
	timer = 0
	needlePos = 0
	engineOffSmoothen = 0
	readyForStartup = false
end 

M.updateGFX = updateGFX
M.init = init
return M