local nodes = require("vehicleeditor.nodes")
groundModels = {}    -- Intentionally global
groundModelsLut = {} -- Intentionally global
beamstate = require("beamstate")
local slipspeedGlobal = 0
local slipDerivativeGlobal = 0
local angleRMemory = 0
local angleRPrev = 0
local angleRMemory2 = 0
local angleRPrev2 = 0
local tyreGripGlobal = 0
local tyre_data = require("tyreData")
local tyre_utils = require("tyre_utils")
local tyre_dataS = require("tyreDataSlip")
local tyre_dataSD = require("tyreDataSlipDirt")
local tyre_init_data = {}


local M = {}



local tyreGripTable = {}


local tyreData = {}
local wheelCache = {}

local totalTimeMod60 = 0

local degubStepFinished = true


-- Calculate tyre wear and thermals based on tyre data
local function gripFromAngle(angleR)
    if not angleR or angleR ~= angleR then return 0.9 end -- NaN fallback
	local slipangle = 10
	local griploss = 0.08
	local initialGrip = 1 - griploss
    if angleR <= slipangle then
        local t = angleR / slipangle
		return initialGrip + griploss * math.cos(t * math.pi/2)
        --return math.max( (initialGrip + griploss * math.sin(t * math.pi/2)), math.min(1,slipspeed/0.2))
    elseif angleR <= (180-slipangle) then
        return 1.0
    elseif angleR <= 180 then
        local t = (180 - angleR) / slipangle
        return initialGrip + griploss * math.cos(t * math.pi/2)
    else
        return initialGrip
    end
end

local function GetGroundModelData(id)
    local materials, materialsMap = particles.getMaterialsParticlesTable()
    local matData = materials[id] or {}
    local name = matData.name or "DOESNT EXIST"
    local name = groundModelsLut[id] or "DOESNT EXIST"
    -- local data = groundModels[name] or { staticFrictionCoefficient = 1, slidingFrictionCoefficient = 1 }
    return name
end


local function CalcSlip(angleR, velocity, angularVel, radius)
    local dirFactor = math.max(0.01, math.abs(math.cos(math.rad(angleR))))
    return (math.abs(angularVel) * radius * dirFactor - velocity)
end


local function CalculateTyreGrip(wheelID, treadCoef, radius, angularVel, airspeed, tyreWidth, 
	groundModelName, velocity, percentageLoad, angleR, propulsionTorque,slipspeedGlobal,dt,totalLoad,flancHeight,softnessCoef,slipDerivativeGlobal, 
	angleR2, treadCoef2)
    local data = tyreData[wheelID]
	local validSurfaceTypes = {
        DIRT = true, SAND = true, MUD = true, GRAVEL = true
    }


	local tyreGrip = 1
	local slipvariance
	local slipVelocity = CalcSlip(angleR,velocity,angularVel,radius)
	local slipspeed = slipVelocity * 1000 / velocity



    local angleGrip = gripFromAngle(angleR)

	if validSurfaceTypes[groundModelName] then
		tyreGrip = 0.94 * tyreGrip

		slipvariance = tyre_dataSD.SlipDirtToGrip.slicks[math.floor(slipspeed)] or 0.686
		slipvariance= slipvariance / 10
		if angularVel == 0 then
			slipvariance = 0.3
		end
		tyreGrip = tyreGrip * (1.0 + slipvariance) --* adherence 
	else
		--tyreGrip = 0.9433962
		tyreGrip = 0.97 * tyreGrip
		slipvariance = tyre_dataS.SlipToGrip.slicks[math.floor(slipspeed)] or 0
		slipvariance = slipvariance * 0.3
		tyreGrip = tyreGrip * (1.0 + slipvariance) * angleGrip

	end
    

	


		
	tyreGripTable[wheelID] = tyreGrip

    return tyreGrip
end


-- This is a special function that runs every frame, and has full access to
-- vehicle data for the current vehicle.
local function updateGFX(dt,slipspeedGlobal,slipDerivativeGlobal)

	-- Total load
	

    local stream = { data = {} }
	
	local totalLoad = 0
	for _, wd in pairs(wheels.wheelRotators) do
		totalLoad = totalLoad + (wd.downForceRaw or 0)
	end

	-- Sécurité pour éviter division par zéro
	if totalLoad < 1 then totalLoad = 1 end

	
    for i, wd in pairs(wheels.wheelRotators) do
        local w = wheelCache[i] or {}
        w.name = wd.name
        w.radius = wd.radius
        w.width = wd.tireWidth
        w.wheelDir = wd.wheelDir
        w.angularVelocity = wd.angularVelocity
        w.downForce = wd.downForce
        w.contactMaterialID1 = wd.contactMaterialID1
        w.contactMaterialID2 = wd.contactMaterialID2
        w.treadCoef = wd.treadCoef
        w.softnessCoef = wd.softnessCoef
        w.isBroken = wd.isBroken
		w.velocity = wd.velocity
        w.downForceRaw = wd.downForceRaw
		
        w.brakeSurfaceTemperature = wd.brakeSurfaceTemperature or ENV_TEMP -- Fixes AI
		w.loadPercent = (wd.downForceRaw or 0) / totalLoad
		w.flancHeight = wd.radius - wd.hubRadius
        -- Get camber data
        -- node1 is outside rim, node2 is inside

        local vectorUp = obj:getDirectionVectorUp()
		
        local localVectNode1 = obj:getNodePosition(wd.node1)
        local localVectNode2 = obj:getNodePosition(wd.node2)
        local vectorWheelForward = (localVectNode2 - localVectNode1):cross(vectorUp)
        local vectorWheelUp = vectorWheelForward:cross(localVectNode2 - localVectNode1)
        local surfaceNormal = mapmgr.surfaceNormalBelow(
            obj:getPosition() + (localVectNode2 + localVectNode1) / 2 - wd.radius * vectorWheelUp:normalized(), 0.1
        )
				-- Obtenir la vitesse du véhicule
		--local vel = obj:getVelocity()
		local vel= obj:getVelocity()
		local moveDir = vec3(velocity)
		local moveCarDir = vec3(vel.x, vel.y, vel.z)
		
		-- On ne calcule que si la voiture est réellement en mouvement
		if moveDir:length() > 0.1 then
			moveCarDir:normalize()
			moveDir:normalize()

			-- Construction de la direction de la roue via ses nœuds
			local vectorUp = obj:getDirectionVectorUp()
			local node1 = obj:getNodePosition(wd.node1)
			local node2 = obj:getNodePosition(wd.node2)

			-- Vecteur avant de la roue = axe de roue × verticale du châssis
			local wheelForward = (node2 - node1):cross(vectorUp)

			-- Sécurité si vecteur nul
			if wheelForward:length() > 0.001 then
				wheelForward:normalize()

				-- Projection au sol pour comparer dans le plan horizontal
				local wheelDir = vec3(wheelForward.x, wheelForward.y, wheelForward.z)
				if wheelDir:length() > 0.001 then
					wheelDir:normalize()

					-- Produit scalaire + angle sécurisé
					local dot = math.max(-1, math.min(1, wheelDir:dot(moveDir)))
					local dot2 = math.max(-1, math.min(1, moveDir:dot(moveCarDir)))
					local angle = math.acos(dot)
					local angle2 = math.acos(dot2)
					local angleDeg = math.abs(math.deg(angle))
					local angleDeg2 = math.abs(math.deg(angle2))

					-- Assignation
					w.AngleR = angleDeg
					w.AngleR2 = angleDeg2
				else
					w.AngleR = 0
					w.AngleR2 = 0
				end
			else
				w.AngleR = 0
				w.AngleR2 = 0
			end
		else
			w.AngleR = 0
			w.AngleR2 = 0
		end
		
        wheelCache[i] = w
    end
	
    local gx = sensors.gx / 9.81
    -- f-b
    local gy = sensors.gy / 9.81
    -- u-d
    local gz = sensors.gz / 9.81
    local g_horiz = math.sqrt(gx * gx + gy * gy)
    local g_table = { gx = gx, gy = gy, gz = gz, g_horiz = g_horiz }

    local vehicleAirspeed = electrics.values.airflowspeed

    for i = 0, #wheels.wheelRotators do
        local wheel = obj:getWheel(i)
        if wheel then
            local groundModelName = GetGroundModelData(wheelCache[i].contactMaterialID1)


            local brakeTemp = wheelCache[i].brakeSurfaceTemperature

			local angularVel2 = math.abs(wheelCache[i].angularVelocity) 
			local speedGround = vec3(wheelCache[i].velocity):length()
			local treadCoef2 = wheelCache[i].treadCoef
            local treadCoef = 1.0 - wheelCache[i].treadCoef * 0.45
            local softnessCoef = wheelCache[i].softnessCoef


            local tyreGrip = CalculateTyreGrip(i, treadCoef, wheelCache[i].radius, angularVel2, vehicleAirspeed, wheelCache[i].width, wheelCache[i].groundModelName, 
				speedGround, wheelCache[i].loadPercent, wheelCache[i].AngleR, propulsionTorque,slipspeedGlobal,dt, totalLoad,wheelCache[i].flancHeight,wheelCache[i].softnessCoef,
				slipDerivativeGlobal, wheelCache[i].AngleR2, treadCoef2)--*wheelCache[i].finalGrip



            table.insert(stream.data, {
                name = wheelCache[i].name,
                tread_coef = treadCoef,
                tyreGrip = math.floor(tyreGrip * 1000) / 1000,
                contact_material = groundModelName,

            })


            wheel:setFrictionThermalSensitivity(
                -300,     -- frictionLowTemp              default: -300
                1e7,      -- frictionHighTemp             default: 1e7
                1e-10,    -- frictionLowSlope             default: 1e-10
                1e-10,    -- frictionHighSlope            default: 1e-10
                10,       -- frictionSlopeSmoothCoef      default: 10
                tyreGrip, -- frictionCoefLow              default: 1
                tyreGrip, -- frictionCoefMiddle           default: 1
                tyreGrip  -- frictionCoefHigh             default: 1
            )
        end
    end
    totalTimeMod60 = (totalTimeMod60 + dt) % 60 -- Loops every 60 seconds
    stream.total_time_mod_60 = totalTimeMod60
    gui.send("TyreWearThermals", stream)
end



local function onReset()

end

local function onInit()

end

local function vSettingsDebug()
    local count = 0
    htmlTools.dumpToFile(obj.partConfig, "obj")
end

local function onSettingsChanged()

end

local function onVehicleSpawned()
end

M.onSettingsChanged = onSettingsChanged
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX
M.onVehicleSpawned = onVehicleSpawned
M.groundModelsCallback = groundModelsCallback

return M



-- local function CalculateTyreGrip(wheelID, loadBias, treadCoef, radius, angularVel, airspeed, tyreWidth, 
	-- groundModelName, velocity, percentageLoad, angleR, propulsionTorque,slipspeedGlobal,dt,totalLoad,flancHeight,softnessCoef,slipDerivativeGlobal)
    -- local data = tyreData[wheelID]
	-- local validSurfaceTypes = {
        -- DIRT = true, SAND = true, MUD = true, GRAVEL = true
    -- }
	-- local T_opt, sigma, minAdherence, maxAdherence, minGrip, maxGrip
	-- local mu_statique = 0.06  -- Coefficient de friction statique
	-- local mu_glissement = 0.001  -- Coefficient de friction dynamique
	-- local sigma2 = 5  -- Largeur de la transitio
	-- local sharpness = 0.000001
    -- local avgTemp = TempRingsToAvgTemp(data.temp, loadBias)
	-- local loadOptimal
	-- local tyreGrip
	-- local slipvariance
	-- local slipVelocity = CalcSlip(angleR,velocity,angularVel,radius)
-- Initialisation
	-- local slipspeed = math.abs(slipVelocity * 1000 / velocity)
	-- local linearCoefficientTimer = 600
	
	-- local boostFactor

	-- local maxBoost 
	-- local slipDerivative
	-- local activeBoost
	-- local numerator
	-- local denominator
	
	
	-- if treadCoef > 0.974 then
        -- Pneus slick
		-- T_opt = 100
        -- sigma = 30
        -- minAdherence = 0.97
        -- maxAdherence = 1.0
		

    -- elseif treadCoef >= 0.112 then
        -- Pneus routiers
        -- T_opt = 50.0
        -- sigma = 50
        -- minAdherence = 0.986
        -- maxAdherence = 1.0

    -- else
        -- Pneus offroad
        -- T_opt = 45.0
        -- sigma = 60
        -- minAdherence = 0.97
        -- maxAdherence = 1.0
		

    -- end
	-- local angleGrip = gripFromAngle(angleR)
	-- if validSurfaceTypes[groundModelName] then
		-- tyreGrip = 0.94

		-- slipvariance = tyre_dataSD.SlipDirtToGrip.slicks[math.floor(slipspeed)] or 0.686
		-- slipvariance= slipvariance / 10
		-- if angularVel == 0 then
			-- slipvariance = 0.30
		-- end

	-- else
		-- tyreGrip = 0.9433962
		-- tyreGrip = 1
		-- slipspeed = math.max(0,slipspeed)
		--slipvariance = (1-math.exp(-20*slipspeed))--tyre_dataS.SlipToGrip.slicks[math.floor(slipspeed)] or 0
		-- slipDerivative = ((1+variance) - (slipspeedGlobal or 0)) / (dt)
	
		

		
		--numerator = (slipvariance-(slipspeedGlobal or 0)) + 1/20 * (math.exp(-20 * slipvariance) - math.exp(-20 * (slipspeedGlobal or 0)))
		--denominator = (slipvariance-(slipspeedGlobal or 0)) * (2 - math.exp(-20 * slipvariance) - math.exp(-20 * (slipspeedGlobal or 0)))/2
		-- local linearCoefficientTimer = 600
		-- if slipDerivativeGlobal > 0 then
			-- slipDerivativeGlobal = math.max(0, slipDerivativeGlobal - linearCoefficientTimer * dt)
		-- end
	
		
		-- local boostFactor = slipDerivativeGlobal / 300

		-- local maxBoost = getMaxBoostFromLoad(totalLoad)
		-- local activeBoost = maxBoost * boostFactor
		--local activeBoost = math.abs(numerator / denominator - 1) 
		-- slipspeedGlobal = slipvariance
		-- slipDerivativeGlobal = activeBoost + (slipDerivativeGlobal or 0)
		-- activeBoost = math.min(0.3, slipDerivativeGlobal)
		-- local linearCoefficientTimer = 600
		-- if slipDerivativeGlobal > 0 then
			-- slipDerivativeGlobal = math.max(0, slipDerivativeGlobal - 0.3)
		-- end

	-- end
    
	-- local loadPercent = percentageLoad * 100
    -- local exponentLoad = -((loadPercent - 40)^2) / (2 * sigma^2)

	
    -- tyreGrip = tyreGrip * 0.7701504+0.002476352*data.condition+0.0001259966*data.condition^(2)-0.000002465426*data.condition^(3)+1.187875*10^(-8)*data.condition^(4)
	-- local exponent = -((avgTemp - T_opt)^(2)) / (2 * sigma^(2))
    -- local adherence = minAdherence + (maxAdherence - minAdherence) * math.exp(exponent)
	
	


    -- tyreGrip = tyreGrip * adherence * slipvariance * angleGrip * (1+(activeBoost or 0))     --(1.0 + activeBoost*1)
    
    -- tyreGripTable[wheelID] = tyreGrip

    -- return tyreGrip
-- end





	-- if angleR>2 then
		-- if not dAngleR2 == 0 then
			-- local contribution2 = (1 - math.min(math.abs(dAngleR2) / 0.3, 1.0)) * 0.01  -- montée lente pour petites dérivées
			-- angleRMemory2 = math.min(0.3, angleRMemory2 + contribution2)
		-- else
			-- angleRMemory2 = 0
		-- end
		-- if not dAngleR == 0 then
			-- local contribution = (1 - math.min(math.min(dAngleR) / 0.3, 1.0)) * 0.01  -- montée lente pour petites dérivées
			-- angleRMemory = math.min(0.3, angleRMemory + contribution)
		-- else
			-- angleRMemory = 0
		-- end
	-- else
		-- if not dAngleR2 == 0 then
			-- local contribution2 = (1 + math.min(math.min(dAngleR2) / 0.3, 1.0)) * 0.01  -- montée lente pour petites dérivées
			-- angleRMemory2 = math.min(0.3, angleRMemory2 + contribution2)
		-- else
			-- angleRMemory2 = 0
		-- end
		-- if not dAngleR == 0 then
			-- local contribution = (1 + math.min(math.min(dAngleR) / 0.3, 1.0)) * 0.01  -- montée lente pour petites dérivées
			-- angleRMemory = math.min(0.3, angleRMemory + contribution)
		-- else
			-- angleRMemory = 0
		-- end
	-- end
	
	
		
	-- if velocity >0.5 then
		-- tyreGrip = tyreGrip * adherence * (1.0 + slipvariance) * angleGrip *(1.0 + 0.4*activeBoost*(tyreWidth/0.3)*(0.67+(1-softnessCoef)/3)) *
			-- (1+angleRMemory) * (1+angleRMemory2)
		-- local griploss = tyreGrip - (tyreGripGlobal or 0)
		-- local tyreGripDerivative = griploss / dt
		-- tyreGripGlobal = tyreGrip
		


		-- local A = -0.002 
		-- local B = 0.2 

		-- tyreGrip= tyreGrip - math.min(0.5*griploss, griploss* A * (1 - math.exp(tyreGripDerivative /(-B*20))))
	-- end
	
	
	
		-- local loadPercent = percentageLoad * 100
    -- local exponentLoad = -((loadPercent - 40)^2) / (2 * sigma^2)

	

	-- if treadCoef > 0.974 then
        -- Pneus slick
		-- T_opt = 100
        -- sigma = 30
        -- minAdherence = 0.97
        -- maxAdherence = 1.0
		

    -- elseif treadCoef >= 0.112 then
        -- Pneus routiers
        -- T_opt = 50.0
        -- sigma = 50
        -- minAdherence = 0.986
        -- maxAdherence = 1.0

    -- else
        -- Pneus offroad
        -- T_opt = 45.0
        -- sigma = 60
        -- minAdherence = 0.97
        -- maxAdherence = 1.0
		

    -- end
	-- tyreGrip = tyreGrip * 0.7701504+0.002476352*data.condition+0.0001259966*data.condition^(2)-0.000002465426*data.condition^(3)+1.187875*10^(-8)*data.condition^(4)
	-- local exponent = -((avgTemp - T_opt)^(2)) / (2 * sigma^(2))
    -- local adherence = minAdherence + (maxAdherence - minAdherence) * math.exp(exponent)
	--local angleGrip = gripFromAngle(angleR)