angular.module('gaugesScreen', [])
  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var speedoDisplay = { gears: {} };
    var navDisplay = {};
	var text = {  };
    var infoDisplay = {};
    var consumGraph = {values:{current: 0,avg: 0}};
    var electrics = {lights:{} };
    var gForcesVisible = false;

    var backgroundGradient = {};
    var overlayGradient = {};
    var navMarkerGradient = {};

    var speedoInitialised = false;
    var currentGear = '';
	var prevRpmAng = 0;

    var ready = false;

    var unit = "metric";
	var units = {uiUnitTemperature: "c"};
    var unitspeedratio = 3.6/260*Math.PI*1.5;

    function setTheme(hue) {
      // speedo
      speedoDisplay.needle_bar.css({'stroke': `hsl(${hue}, 70%, 50%)`, 'stroke-width': '0.5px'});

      // info
      infoDisplay.infoOverlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // info
      navDisplay.overlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // gradients
      overlayGradient.stop1.css({stopColor: `hsl(${hue}, 100%, 20%)`})
      overlayGradient.stop2.css({stopColor: `hsl(${hue}, 100%, 10%)`})

      backgroundGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 0%)`})
      backgroundGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 0%)`})

      navMarkerGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 50%)`})
      navMarkerGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 30%)`})

      // background color
      $element[0].style.backgroundColor = "black";
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[1].children[0];
	  
      // speedometer
      speedoDisplay.root = hu('#speedometer', svg);
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root)
      speedoDisplay.speedValue = hu('#speedValue', speedoDisplay.speedometerText);
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.speedometerText);
      speedoDisplay.gears.P = hu('#gearP', speedoDisplay.speedometerText);
      speedoDisplay.gears.R = hu('#gearR', speedoDisplay.speedometerText);
      speedoDisplay.gears.N = hu('#gearN', speedoDisplay.speedometerText);
      speedoDisplay.gears.D = hu('#gearD', speedoDisplay.speedometerText);
      speedoDisplay.gears.S = hu('#gearS', speedoDisplay.speedometerText);
	  speedoDisplay.oilTempValue = hu('#oilTempValue', speedoDisplay.speedometerText);
	  speedoDisplay.waterTempValue = hu('#waterTempValue', speedoDisplay.speedometerText);
	  speedoDisplay.needle = hu('#needle', speedoDisplay.root);
	  speedoDisplay.needle_peak = hu('#needle_peak', speedoDisplay.root);
	  speedoDisplay.Ticket = hu('#Ticket', speedoDisplay.Ticket);
	  speedoDisplay.TicketWaterTemp = hu('#TicketWaterTemp', speedoDisplay.TicketWaterTemp);
	  speedoDisplay.LeftMenu = hu('#LeftMenu', speedoDisplay.LeftMenu);
	  speedoDisplay.MaxRPM_fadein = hu('#MaxRPM_fadein', speedoDisplay.MaxRPM);
	  speedoDisplay.LogoSnake_fadein = hu('#LogoSnake_fadein', speedoDisplay.LogoSnake);
	  speedoDisplay.ESCpage = hu('#ESCpage', speedoDisplay.ESCpage);
	  speedoDisplay.StabMODE = hu('#StabMODE', speedoDisplay.ESCpage);
	  speedoDisplay.TracMODE = hu('#TracMODE', speedoDisplay.ESCpage);
	  speedoDisplay.tires_pressure = {
        FR: hu('#tpres_FR', speedoDisplay.TirePres), // Переднее правое
        FL: hu('#tpres_FL', speedoDisplay.TirePres), // Переднее левое
        RR: hu('#tpres_RR', speedoDisplay.TirePres), // Заднее правое
        RL: hu('#tpres_RL', speedoDisplay.TirePres)  // Заднее левое
	  };
	  speedoDisplay.tires_temperature = {
        FR: hu('#ttemp_FR', speedoDisplay.TireTemp), // Переднее правое
        FL: hu('#ttemp_FL', speedoDisplay.TireTemp), // Переднее левое
        RR: hu('#ttemp_RR', speedoDisplay.TireTemp), // Заднее правое
        RL: hu('#ttemp_RL', speedoDisplay.TireTemp)  // Заднее левое
	  };
      speedoDisplay.needle.attr({class: "fade-in"}).css({stroke: "#ffffff"});
      speedoDisplay.needle_bar = hu('#needle_bar', speedoDisplay.root);
      speedoDisplay.needle_bar.attr({class: "fade-in"});
      speedoDisplay.needle_gradients = [];
      speedoDisplay.needle_gradients.push(hu('#radialGradient965', svg));
      speedoDisplay.needle_gradients.push(hu('#radialGradient977', svg));
	  
	  text.temp_unitWater = hu('#waterTempUnit', speedoDisplay.root);
	  text.temp_unitOil = hu('#oilTempUnit', speedoDisplay.root);

      // info
      infoDisplay.root = hu('#information', svg);
      infoDisplay.infoOverlay = hu('#infoOverlay', infoDisplay.root);
      infoDisplay.infoValues = hu('#infoValues', infoDisplay.root);

      infoDisplay.accelerometer = hu('#accelerometer', infoDisplay.root);
      infoDisplay.accelerometerMarker = hu('#accelerometerMarker', infoDisplay.accelerometer);
      infoDisplay.gXNegative = hu('#gXNegative', infoDisplay.root);
      infoDisplay.gXPositive = hu('#gXPositive', infoDisplay.root);
      infoDisplay.gYNegative = hu('#gYNegative', infoDisplay.root);
      infoDisplay.gYPositive = hu('#gYPositive', infoDisplay.root);

      /* consumGraph.root = hu('#consum_graph_layer', svg);
      consumGraph.graph_canvas = document.getElementById('consum_graph_canvas');
      consumGraph.graph_canvas_ctx = consumGraph.graph_canvas.getContext("2d");
      consumGraph.graph_canvas_gradiant_o = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_o.addColorStop(1, 'rgba(0,0,0,0.0)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(1, 'rgba(0,0,0,0)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(1, 'rgba(0,0,0,0)');
      consumGraph.graph_canvas_gradiant_g = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_g.addColorStop(1, 'rgba(0,0,0,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(1, 'rgba(0,0,0,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(1, 'rgba(0,0,0,0.0)'); */

	  speedoDisplay.ESCpage.n.style.display = "none";
	  infoDisplay.accelerometer.css({opacity: 0})
      infoDisplay.infoValues.css({opacity: 0})
      infoDisplay.infoValuesTxt = { range: hu('#rangeTxt', infoDisplay.infoValues),
        now: hu('#nowTxt', infoDisplay.infoValues),
        avg: hu('#avgTxt', infoDisplay.infoValues),
        odo: hu('#odoTxt', infoDisplay.infoValues),
      };

      // nav
      navDisplay.root = hu('#navigation', svg);
      navDisplay.overlay = hu('#MapOverlay', navDisplay.root);

      // animations
      speedoDisplay.root.attr({class: "fade-in"}).on('webkitAnimationEnd', function (){
      });
      speedoInitialised = true;
      speedoDisplay.needle.on('webkitAnimationEnd', function (){
        speedoInitialised = true;
      });

      speedoDisplay.speedometerText.attr({class: "fade-in"})
	  speedoDisplay.Ticket.attr({class: "fade-in"})
	  speedoDisplay.LeftMenu.attr({class: "fade-in"})
	  speedoDisplay.TicketWaterTemp.attr({class: "fade-in"})
      infoDisplay.root.attr({class: "slide-right"});
      navDisplay.root.attr({class: "slide-left"});
      var background = hu('#background', svg);
      background.attr({class: 'map-fade'})

      // gradients
      overlayGradient.stop1 = hu('#overlayStop1', svg);
      overlayGradient.stop2 = hu('#overlayStop2', svg);
      backgroundGradient.stop1 = hu('#bgStop1', svg);
      backgroundGradient.stop2 = hu('#bgStop2', svg);
      navMarkerGradient.stop1 = hu('#navStop1', svg);
      navMarkerGradient.stop2 = hu('#navStop2', svg);

      electrics.root = hu('#lights_layer', svg);
      electrics.lights.signal_L = hu("#light_signal_L", electrics.root);
      electrics.lights.signal_R = hu("#light_signal_R", electrics.root);
      electrics.lights.lights = hu("#light_lights", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.fog = hu("#light_fog", electrics.root);
      electrics.lights.lowpressure = hu("#light_lowpressure", electrics.root);
	  electrics.mode_txt = hu("#mode_txt", electrics.root);
	  electrics.ModeTEXT = hu("#ModeTEXT", speedoDisplay.ESCpage);
	  electrics.tcs = hu("#light_tcsActive", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
	  electrics.lights.cruiseControlActive = hu('#cruisecontrol_light', electrics.root)
      electrics.lights.lowfuel = hu("#light_lowfuel", electrics.root);
	  electrics.fuelTxt = hu("#fuelTxt", speedoDisplay.speedometerText);
	  electrics.waterStops = [hu("#stop_water1", svg), hu("#stop_water2", svg)];
      electrics.fuelStops = [hu("#stop_fuel1", svg), hu("#stop_fuel2", svg)];

      if(new Date().getDate() ==1 && new Date().getMonth() == 3){
        var ellogo = hu('#imageLogo', svg);
        if(ellogo)ellogo.attr({href: "/core/art/missingTexture.png"});
      }
      setTheme(200);

      //default `Comfort` display graph and conso
      infoDisplay.accelerometer.css({opacity: 0});
      //consumGraph.root.css({opacity: 0});
      //consumGraph.graph_canvas.style.display = "inline";
      infoDisplay.infoValues.css({opacity: 1});
    }

    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        for (var key in speedoDisplay.gears) {
          if (key === data.electrics.gear) {
            speedoDisplay.gears[key].css({ fill: '#FFFFFF' })
          }
          else {
            speedoDisplay.gears[key].css({ fill: '#616161' })
          }
        }
      }
    }

    function updateSpeedDisplays(data) {
      if (speedoInitialised) {
        speedoDisplay.speedValue.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));
      }
    }
	
	var prevPeakRpmRad = -211 * Math.PI / 180; // Угол фиксации максимума
var peakHoldTimeout = null; // Таймер сброса стрелки
var needle_peakTimeout = null; // Таймер скрытия стрелки peak
var peakResetting = false; // Флаг сброса стрелки

// Устанавливаем регулярный сброс стрелки каждые 5 секунд
setInterval(() => {
    prevPeakRpmRad = prevRpmAng; // Сбрасываем стрелку в положение основной стрелки
}, 5000);

function updateTachoDisplays(data) { 
    if (speedoInitialised) {
        var rpmAng = 226 + (data.electrics.rpmTacho * 0.1);
        var startAngle = -211 * Math.PI / 180;
        var rpmRad = (data.electrics.rpmTacho * 0.00052) + startAngle;
        var maxRad = (211.5 * Math.PI / 180) + startAngle;
        rpmRad = Math.min(rpmRad, maxRad);

        if (Math.abs(rpmRad - prevRpmAng) < 0.01) { 
            return; 
        }

        var centerX = 67.7, centerY = 35.8, radiusInt = 21.2;
        var ex1 = centerX + Math.cos(rpmRad) * radiusInt;
        var ey1 = centerY + Math.sin(rpmRad) * radiusInt;
        var mx1 = centerX + Math.cos(rpmRad) * 13.8;
        var my1 = centerY + Math.sin(rpmRad) * 13.8;

        speedoDisplay.needle.attr({ d: "M " + ex1 + "," + ey1 + " " + mx1 + "," + my1 });

        // **Фиксация максимальных оборотов**
        if (!peakResetting && rpmRad > prevPeakRpmRad) {
            prevPeakRpmRad = rpmRad;

            // Если стрелка обновила максимум, сбрасываем старый таймер и создаём новый
            if (peakHoldTimeout) clearTimeout(peakHoldTimeout);
            peakHoldTimeout = setTimeout(() => {
                peakResetting = true; // Начинаем сброс
            }, 5000);
        }

        // **Плавный сброс стрелки peak**
        if (peakResetting) {
            prevPeakRpmRad -= 1; // Плавное движение вниз
            if (prevPeakRpmRad <= rpmRad) { 
                prevPeakRpmRad = rpmRad; // Как только догнали основную стрелку, фиксируем
                peakResetting = false; // Сброс завершён
            }
        }

        // **Обновление второй стрелки needle_peak**
        if (speedoDisplay.needle_peak) {
            if (data.electrics.rpmTacho >= 4000) {
                // Очищаем таймер исчезновения, если он был запущен
                if (needle_peakTimeout) {
                    clearTimeout(needle_peakTimeout);
                    needle_peakTimeout = null;
                }

                // Показываем стрелку
                speedoDisplay.needle_peak.css({ opacity: 0.3, display: "block", stroke: "#0036ff" });
            } else {
                // Если обороты упали ниже 4000, запускаем таймер на 3 секунды перед скрытием
                if (!needle_peakTimeout) {
                    needle_peakTimeout = setTimeout(() => {
                        speedoDisplay.needle_peak.css({ opacity: 0, display: "none" });
                        needle_peakTimeout = null; // Сбрасываем таймер
                    }, 3000);
                }
            }

            // **Обновление положения стрелки**
            var ex2 = centerX + Math.cos(prevPeakRpmRad) * radiusInt;
            var ey2 = centerY + Math.sin(prevPeakRpmRad) * radiusInt;
            var mx2 = centerX + Math.cos(prevPeakRpmRad) * 13.8;
            var my2 = centerY + Math.sin(prevPeakRpmRad) * 13.8;
            speedoDisplay.needle_peak.attr({ d: "M " + ex2 + "," + ey2 + " " + mx2 + "," + my2 });
        }

        // **Анимация логотипа и индикатора Max RPM**
        const minRpm = 5500;
        const maxRpm = 6300;
        const rpm = data.electrics.rpmTacho;

        if (rpm >= minRpm && rpm <= maxRpm) {
            const opacity = (rpm - minRpm) / (maxRpm - minRpm);

            if (speedoDisplay.MaxRPM_fadein) {
                speedoDisplay.MaxRPM_fadein.css({ opacity: opacity });
            }
            if (speedoDisplay.LogoSnake_fadein) {
                speedoDisplay.LogoSnake_fadein.css({ opacity: opacity });
            }
        } else if (rpm > maxRpm) {
            if (speedoDisplay.MaxRPM_fadein) {
                speedoDisplay.MaxRPM_fadein.css({ opacity: 1 });
            }
            if (speedoDisplay.LogoSnake_fadein) {
                speedoDisplay.LogoSnake_fadein.css({ opacity: 1 });
            }
        } else {
            if (speedoDisplay.MaxRPM_fadein) {
                speedoDisplay.MaxRPM_fadein.css({ opacity: 0 });
            }
            if (speedoDisplay.LogoSnake_fadein) {
                speedoDisplay.LogoSnake_fadein.css({ opacity: 0 });
            }
        }

        prevRpmAng = rpmRad;
    }
}

    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }
	  
	  unit = data.uiUnitLength;
      if( unit === "metric"){
        unitspeedratio = 3.6/data.maxKPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("km/h");
      }
      else{
        unitspeedratio = 2.23694/data.maxMPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("mph");
      }
	  units.uiUnitTemperature = data.uiUnitTemperature || ""
    }


    $window.initMap = (data) => {
      navDimensions = data.viewParams = [
        data.terrainOffset[0],
        data.terrainOffset[1],
        data.terrainSize[0],
        data.terrainSize[1]
      ];

      $scope.$apply(() => {
        vm.mapData = data;
      });

      navContainer.style.width = data.terrainSize[0] + "px";
      navContainer.style.height = data.terrainSize[1] + "px";
    }

    $window.updateMap = (data) => {
      var focusX = -data.x;
      var focusY = data.y;
      var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
      navContainer.style.transformOrigin = origin;
      var translateX = ((((navDimensions[0])) + 512) + focusX);
      var translateY = ((((navDimensions[1])) + 256) + focusY);
      navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${55}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(1)`;
    }

    var hue = 0;


    function setElec(val, state, key){
      if( val === undefined || val === null){/*console.error("setElec: svg element not found", key);*/ return;}
      if( state === undefined || state === null){/*console.error("setElec: state not found", key);*/ return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
    }

    $window.updateElectrics = (data) => {
      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }
	  
	  if(data.electrics.cruiseControlActive === undefined){data.electrics.cruiseControlActive = false}
	  
	   electrics.tcs.n.style.display = (data.electrics["tcsActive"] || data.electrics["tcs"]==1 ) ?"inline":"none";
      if( electrics.tcs.n.classList.contains("blink") !== (data.electrics["tcsActive"])){
        electrics.tcs.n.classList.toggle("blink", (data.electrics["tcsActive"]));
      } 
	  
	  if(units.uiUnitTemperature == "c" || units.uiUnitTemperature == "k"){
		let envTempOil = data.electrics.oiltemp
		speedoDisplay.oilTempValue.text( envTempOil.toFixed(0) );
		text.temp_unitOil.text( "°C" );
      }else{
		let envTempOil = (data.electrics.oiltemp * 9/5) + 32
		speedoDisplay.oilTempValue.text( envTempOil.toFixed(0) );
		text.temp_unitOil.text( "°F" );
      }
	  
      // Константы
	  const maxFuel = 70; // Максимальный объем бака в литрах
	  const fuelConsumption = 30.5; // Средний расход топлива в л/100 км

	  // Получение текущего значения топлива (доля от полного бака)
	  const currentFuelFraction = data.electrics.fuel;

	  // Переводим в литры
	  const currentFuel = currentFuelFraction * maxFuel;

	  // Рассчитываем оставшийся пробег в километрах
	  let remainingRange = (currentFuel / fuelConsumption) * 100;

	  // Конвертируем в мили, если выбрана система "imperial"
	  if (unit === "imperial") {
	  remainingRange *= 0.621371; // Перевод из километров в мили
	  }

	  // Обновляем текстовое отображение с единицами измерения
	  electrics.fuelTxt.text(remainingRange.toFixed(0) + (unit === "metric" ? " km" : " mi"));
      electrics.fuelStops[0].attr({offset: data.electrics.fuel})
      electrics.fuelStops[1].attr({offset: data.electrics.fuel+0.001})
	  
	  // Переменная для текущего значения температуры воды (начинаем с 0)
    let currentWaterTemp = 0;

    // Скорость изменения (0.1 = медленно, 0.5 = быстрее)
    const changeSpeed = 0.888;
	
    // Функция для масштабирования
    const scaleToOffset = (value, min, max) => {
        return Math.min(Math.max((value - min) / (max - min), 0), 1);
    };
	
	// Целевое значение температуры воды
    const targetWaterTemp = scaleToOffset(data.electrics.watertemp || 0, 50, 120);
	
	// Интерполяция для плавного изменения температуры воды
    currentWaterTemp += (targetWaterTemp - currentWaterTemp) * changeSpeed;
	  
	// Обновляем градиент
    if (electrics.waterStops[0] && electrics.waterStops[1]) {
        electrics.waterStops[0].attr({ offset: currentWaterTemp });
        electrics.waterStops[1].attr({ offset: currentWaterTemp + 0.001 });
    }
      if(data.electrics.odometer){
        let val = data.electrics.odometer
        val *= (unit=="metric")?0.001:0.0006215;
        val = Math.min(val,999999)
        infoDisplay.infoValuesTxt.odo.text( val.toFixed(0) + (unit==="metric"?" km":" mi") );
      }
    }

    $window.updateData = (data) => {
      if (data) {

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        updateSpeedDisplays(data);
		// Update Tacho displays
		updateTachoDisplays(data);

        updateElectrics(data);
		
		$window.setTirePressure(data.customModules.tireData.pressures);
		$window.setTireTemperature(data.customModules.tireData.temperatures)
      }
    }
	
	$window.setTirePressure = (data) => {
    if (!data) return;

    const scaleFactor = 6.5; // Коэффициент масштабирования данных (для нормализации)
    const psiToBar = 0.0689476; // Коэффициент преобразования PSI → Bar

    // Обновляем отображение давления
    for (let tire in data) {
        let rawPressureValue = data[tire]; // Давление из данных (например, 195)
        
        // Нормализуем данные: делим на коэффициент масштабирования
        const normalizedPressure = rawPressureValue / scaleFactor;

        // Преобразуем PSI в Bar
        const pressureInBar = normalizedPressure * psiToBar;

        // Устанавливаем значение давления с одной десятичной цифрой
        speedoDisplay.tires_pressure[tire].text(pressureInBar.toFixed(1));
    }
	};
	
	$window.setTireTemperature = (data) => {
    if (!data) return;

    // Функция для преобразования температуры в цвет
    const temperatureToColor = (temperature) => {
        const minTemp = 0;   // Минимальная температура
        const maxTemp = 10; // Максимальная температура

        // Ограничиваем температуру в пределах диапазона
        const normalizedTemp = Math.max(minTemp, Math.min(maxTemp, temperature));

        // Преобразуем температуру в цвет (от синего к красному через зелёный)
        const red = Math.round((normalizedTemp / maxTemp) * 255);
        const green = Math.round((1 - Math.abs(normalizedTemp - maxTemp / 2) / (maxTemp / 2)) * 255);
        const blue = Math.round((1 - normalizedTemp / maxTemp) * 255);

        return `rgb(${red},${green},${blue})`; // Цвет в формате RGB
    };

    // Обновляем цвет для каждого элемента температуры
    for (let tire in data) {
        const temperatureValue = data[tire]; // Температура для текущей шины
        const color = temperatureToColor(temperatureValue); // Получаем цвет

        // Применяем цвет к SVG-элементу
        speedoDisplay.tires_temperature[tire].css({ fill: color });
    }
};

    //https://stackoverflow.com/a/56266358
    function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    function parseColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color;
    }

    function getHue(rgb){
      let sep = rgb.indexOf(",") > -1 ? "," : " ";
      rgb = rgb.substr(4).split(")")[0].split(sep);

      for (let R in rgb) {
        let r = rgb[R];
        if (r.indexOf("%") > -1)
          rgb[R] = Math.round(r.substr(0,r.length - 1) / 100 * 255);
      }

      // Make r, g, and b fractions of 1
      let r = rgb[0] / 255,
          g = rgb[1] / 255,
          b = rgb[2] / 255;


      // Find greatest and smallest channel values
      let cmin = Math.min(r,g,b),
          cmax = Math.max(r,g,b),
          delta = cmax - cmin,
          h = 0,
          s = 0,
          l = 0;

      // Calculate hue
      // No difference
      if (delta == 0)
        h = 0;
      // Red is max
      else if (cmax == r)
        h = ((g - b) / delta) % 6;
      // Green is max
      else if (cmax == g)
        h = (b - r) / delta + 2;
      // Blue is max
      else
        h = (r - g) / delta + 4;

      h = Math.round(h * 60);

      // Make negative hues positive behind 360°
      if (h < 0)
          h += 360;
      return h;
    }

    $window.updateMode = (data) => {
    if (!ready) {
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function () { $window.updateMode(data) }, 100);
        return;
    }
    if (data === null
        || data === undefined
        || data.modeName === null
        || data.modeName === undefined
        || typeof data.modeName !== "string"
        || data.modeColor === null
        || data.modeColor === undefined
        || typeof data.modeColor !== "string") {
        console.error("updateMode receive wrong arguments :", data);
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "MODE";
        return;
    }
    if (!isColor(data.modeColor)) {
        console.error("This mode color is not in html format :", data.modeColor)
        return;
    }

    let h = getHue(parseColor(data.modeColor));
    setTheme(h);

    gForcesVisible = data.modeName != "Comfort";
    electrics.mode_txt.text(data.modeName).css({ fill: data.modeColor });
    electrics.ModeTEXT.text(data.modeName + " Mode").css({ fill: data.modeColor });

    // Показываем ESCpage на 3 секунды
	speedoDisplay.ESCpage.n.style.display = "inline";
    clearTimeout(speedoDisplay.ESCpageTimeout); // Очищаем предыдущий таймер
    speedoDisplay.ESCpageTimeout = setTimeout(() => {
        speedoDisplay.ESCpage.n.style.display = "none"; // Скрываем через 3 секунды
    }, 3000);

    // Настройки TracMODE и StabMODE
    if (data.modeName === "Track") {
        speedoDisplay.TracMODE.text("OFF").css({ fill: '#ff0000' });
        speedoDisplay.StabMODE.text("Reduced").css({ fill: '#ffa800' });
    }
    else if (data.modeName === "Sport") {
        speedoDisplay.TracMODE.text("Reduced").css({ fill: '#ffa800' });
        speedoDisplay.StabMODE.text("Reduced").css({ fill: '#ffa800' });
    }
    else if (data.modeName === "Rain") {
        speedoDisplay.TracMODE.text("On").css({ fill: '#06ff00' });
        speedoDisplay.StabMODE.text("On").css({ fill: '#06ff00' });
    }
    else if (data.modeName === "OFF") {
        speedoDisplay.TracMODE.text("Off").css({ fill: '#ff0000' });
        speedoDisplay.StabMODE.text("Off").css({ fill: '#ff0000' });
    }

    if (gForcesVisible === true) {
        consumGraph.root.css({ opacity: 0 });
        infoDisplay.infoValues.css({ opacity: 0 });
        consumGraph.graph_canvas.style.display = "none";
    }
    else {
        infoDisplay.accelerometer.css({ opacity: 0 });
        consumGraph.root.css({ opacity: 1 });
        consumGraph.graph_canvas.style.display = "inline";
        infoDisplay.infoValues.css({ opacity: 1 });
    }
}
    ready = true;
    //$window.updateConsumption({current:0, average:0, range:0});
  });