-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local function updateGFX(dt)
    if not electrics.values.oilPanLeak then -- since we cannot fix the oilpan without reset anyways
        if damageTracker.getDamage("engine", "oilpanLeak") then
            electrics.values.oilPanLeak = true
        end
    end
end

local function onBeamBroke(cid)
    local beam = v.data.beams[cid]
    if not beam or not beam.deformGroup and not electrics.values.lightBroken then return end

    if tostring(beam.deformGroup):match("light") or tostring(beam.deformGroup):match("signal") or tostring(beam.deformGroup):match("drl") then
        electrics.values.lightBroken = true
    end
end

local function onInit()
    electrics.values.oilPanLeak = 0
    electrics.values.lightBroken = false
end

-- public interface
M.onInit = onInit
M.onReset = onInit
M.onBeamBroke = onBeamBroke
M.updateGFX = updateGFX

return M