// written by DaddelZeit
// DO NOT USE WITHOUT PERMISSION

//console.log("load gaugesScreen");
angular.module('gaugesScreen', [])

.controller('GaugesScreenController', function ($scope, $element, $window) {
  "use strict";
  var vm = this;

  var svg;
  var gauges = {};
  var ready = false;
  var block;
  var boot;

  // Make sure SVG is loaded
  $scope.onSVGLoaded = function () {
    svg = $element[0].children[0].children[0]
    block = hu('#block', svg)
    boot = hu('#boot', svg)
    boot.css({"transition": "opacity 0.5s ease-in-out"})
    generate("power", "POWER")
    generate("boost", "BOOST")
    generate("torque", "TORQUE")
    generate("throttle", "THROTTLE", "PERCENT")
    generate("oiltemp", "ENGINE", "OIL TEMP")
    generate("brake", "BRAKE", "PERCENT")
    ready = true;
  }

  function generate(id, name, name2) {
    let container = hu('#container', gauges.root);
    let template = document.getElementById("template");

    let xpos = 43 + (container.n.children.length-1)%3 * 67
    let ypos = 50 + Math.floor((container.n.children.length-1)/3)*75
    let transform = `translate(${xpos}px, ${ypos}px) scale(0.2)`
    var newGroup = hu('<g>', container)
    newGroup.n.innerHTML = template.innerHTML.replaceAll("template", id);
    newGroup.n.style.display = "inline";
    newGroup.n.style.transform = transform;
    newGroup.n.children[0].children[0].innerHTML = name || "";
    newGroup.n.children[1].children[0].innerHTML = name2 || "";

    document.getElementById(id+"_left_part").style.transformOrigin = `${135.46666}px ${135.46666}px`
    document.getElementById(id+"_right_part").style.transformOrigin = `${135.46666}px ${135.46666}px`
    gauges[id] = gauges[id] || {}
    gauges[id].root = newGroup;
  }

  // overwriting plain javascript function so we can access from within the controller
  $window.setup = (data) => {
    if(!ready){
      console.log("calling setup while svg not fully loaded");
      setTimeout(function(){ $window.setup(data) }, 100);
      return;
    }
  }

  $window.updateMode = (data) => {}

  function updateGauge(id, value, displayValue) {
    document.getElementById(id+"_value").children[0].innerHTML = displayValue

    let temp = Math.max(Math.min(2*value, 1), 0)
    document.getElementById(id+"_left_part").style.transform = `rotateZ(${temp*144-144}deg)`
    temp = Math.max(Math.min(2*value-1, 1), 0)
    document.getElementById(id+"_right_part").style.transform = `rotateZ(${temp*144-144}deg)`
  }

  $window.updateElectrics = (data) => {
    updateGauge("throttle", data.electrics.throttle, (data.electrics.throttle*100).toFixed(0)+"%")
    updateGauge("brake", data.electrics.brake, (data.electrics.brake*100).toFixed(0)+"%")
    let engine = data.powertrain.mainEngine
    let temp = UiUnits.torque(engine.outputTorque1)
    updateGauge("torque", engine.outputTorque1/engine.maxTorque, temp.val.toFixed(0))
    temp = UiUnits.power(Math.max(engine.outputTorque1*engine.outputAV1*0.00135962, 0))
    updateGauge("power", (engine.outputTorque1*engine.outputAV1*0.00135962)/engine.maxPower, temp.val.toFixed(0))
    temp = UiUnits.pressure(data.electrics.boost*6.89476)
    updateGauge("boost", data.electrics.boost/data.electrics.boostMax, temp.val.toFixed(2))
    temp = UiUnits.temperature(data.electrics.oiltemp)
    updateGauge("oiltemp", Math.max(Math.min(data.electrics.oiltemp/120, 120), 0), temp.val.toFixed(0))

    block.css({display: data.electrics.ignitionLevel===0?"inline":"none"})
    boot.css({opacity: data.electrics.ignitionLevel===2?0:1})
  }

  $window.updateData = (data) => {
    if (data) {
      if(!ready || !UiUnits){console.log("not ready");return;}
      updateElectrics(data);
    }
  }
  //ready = true;
  //$window.updateConsum({current:0, average:0, range:0});
});