// written by DaddelZeit
// DO NOT USE WITHOUT PERMISSION

//console.log("load gaugesScreen");
angular.module('gaugesScreen', [])

.controller('GaugesScreenController', function ($scope, $element, $window) {
  "use strict";
  var vm = this;

  var svg;

  var tacho = {};
  var electrics = {lights:{}};
  var gauges = {power:{}, boost:{}, fuel:{}, temp:{}};
  var block;
  var boot;

  var ready = false;
  var rpmRatio = 0.1;
  var redRPM = 0;
  var flashing = false;

  var units = {
    uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  // Make sure SVG is loaded
  $scope.onSVGLoaded = function () {
    svg = $element[0].children[0].children[0];
    block = hu('#block', svg)
    boot = hu('#boot', svg)
    boot.css({"transition": "opacity 0.5s ease-in-out"})

    tacho.root = hu('#tacho', gauges.root)
    tacho.root.n.style.transformOrigin = "135.46666px 135.46666px"
    tacho.ticks = hu('#tacho_ticks', tacho.root)
    tacho.ticksBlur = hu('#tacho_ticks_blur', tacho.root)
    tacho.redline = hu('#redline', tacho.root)
    tacho.needle = hu('#tacho_needle', tacho.root)
    tacho.needle.n.style.transformOrigin = "135.46666px 135.46666px"
    tacho.needleGradient = document.getElementById("tachoGradient")
    tacho.backgroundGradient = document.getElementById("tachoBackgroundGradient")

    gauges.power = hu('#power_indicator', gauges.root)
    gauges.power.n.style.transformOrigin = "135.46666px 135.46666px"
    gauges.boost = hu('#boost_indicator', gauges.root)
    gauges.boost.n.style.transformOrigin = "135.46666px 135.46666px"
    gauges.temp = hu('#temp_indicator', gauges.root)
    gauges.temp.n.style.transformOrigin = "135.46666px 135.46666px"
    gauges.fuel = hu('#fuel_indicator', gauges.root)
    gauges.fuel.n.style.transformOrigin = "135.46666px 135.46666px"

    electrics.gear = hu('#gear', tacho.root)
    electrics.shiftType = hu('#shift_type', tacho.root)
    electrics.speedUnit = hu('#speed_unit', tacho.root)
    electrics.speed = {
      root: hu('#speedometer', tacho.root),
      f0: "#215c8eff",
      f1: "#dbeafeff"
    }
    electrics.speed[0] = hu('#speedometer_digit1', electrics.speed.root)
    electrics.speed[1] = hu('#speedometer_digit10', electrics.speed.root)
    electrics.speed[2] = hu('#speedometer_digit100', electrics.speed.root)

    electrics.lightsRoot = hu('#electrics', tacho.root)
    electrics.lights.lowhighbeam = hu('#lowbeam', electrics.lightsRoot)
    electrics.lights.highbeam = hu('#highbeam', electrics.lightsRoot)
    electrics.lights.fog = hu('#fog', electrics.lightsRoot)
    electrics.lights.hazard_enabled = hu('#hazard', electrics.lightsRoot)
    electrics.lights.parkingbrake = hu('#parking', electrics.lightsRoot)
    electrics.lights.esc = hu('#esc', electrics.lightsRoot)
    electrics.lights.lowpressure = hu('#tirepressure', electrics.lightsRoot)
    electrics.lights.oilPanLeak = hu('#oilpressure', electrics.lightsRoot)

    electrics.lights.signal_R = hu('#signal_r', electrics.lightsRoot)
    electrics.lights.signal_L = hu('#signal_l', electrics.lightsRoot)

    electrics.lights_battery = hu('#battery', electrics.lightsRoot)
    electrics.lights_watertemp = hu('#watertemp', electrics.lightsRoot)
    electrics.lights_seatbelt = hu('#seatbelt', electrics.lightsRoot)

    electrics.lights_battery.css({"display":"none"})
    electrics.lights_seatbelt.css({"display":"none"})

    ready = true;
  }

  function limitVal(min, val,max){
    return Math.min(Math.max(min,val), max);
  }

  function updateGearIndicator(data) {
    let gear = String(data.electrics.gear)
    if (gear[0] === "M") {
      electrics.shiftType.text("MANUAL")
      electrics.gear.text(gear.substring(1))
    } else {
      electrics.shiftType.text("AUTO")
      electrics.gear.text(gear)
    }
  }

  $window.redrawTachoTicks = (lim,bigSep,smallSep,red) => {
    let angle = function(cx, cy, ex, ey) {
      var dy = ey - cy;
      var dx = ex - cx;
      var theta = Math.atan2(dy, dx); // range (-PI, PI]
      theta *= 180 / Math.PI; // rads to degs, range (-180, 180]
      //if (theta < 0) theta = 360 + theta; // range [0, 360)
      return theta;
    }

    tacho.ticks.empty()
    var startAngle = 19.75
    var maxAngle = -283
    var centerX=135.46666, centerY=135.46666, radiusExt=66, radiusInt=57, radiusExtBig=59, txtRadius = 61
    rpmRatio = maxAngle*Math.PI/(lim*180)

    let ibCount = (lim/bigSep)
    let isCount = (bigSep/smallSep)
    let testStyle = {"font-size":"7.0304px","font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"Eurasia","fill-opacity":1,"stroke-width":0.04861574,"text-align":"center","text-anchor":"middle","fill":"#dbeafeff"};

    let last_sx1 = 189.5609
    let last_sy1 = 196.22939
    for(let ib = 0; ib <= ibCount; ib++){
      for(let is = 1; is <= isCount; is++){
        var curAng = (ib*maxAngle/ibCount+maxAngle*(1/ibCount)*(is/isCount))*Math.PI/180
        if(curAng < (maxAngle*Math.PI/180)){break}

        var sx1 = centerX + Math.cos(startAngle+curAng) * (is===2?radiusExtBig:radiusExt)
        var sy1 = centerY + Math.sin(startAngle+curAng) * (is===2?radiusExtBig:radiusExt)

        var sx2 = centerX + Math.cos(startAngle+curAng) * radiusInt
        var sy2 = centerY + Math.sin(startAngle+curAng) * radiusInt

        if (ib !== ibCount-1 || is === 1) {
          hu('<line>', tacho.ticks).attr({
            x1: sx1, y1: sy1,
            x2: sx2, y2: sy2,
            stroke: `#dbeafeff`, strokeWidth: 1
          })

          if (is === 2) {
            var sx = (centerX) + Math.cos(startAngle+curAng) * txtRadius;
            var sy = (centerY) + Math.sin(startAngle+curAng) * txtRadius;

            var textObj = hu('<text>', tacho.ticks)
            .css(testStyle)
            .css({transformOrigin:`${sx}px ${sy}px`, transform:`rotateZ(${angle(centerX, centerY, sx, sy)+90}deg)`});

            hu('<tspan>', textObj)
            .attr({x:sx, y:sy})
            .text(ibCount-(ib*bigSep*0.001)-1)
            .css(testStyle);
          }
        }

        let curRpm = ib*bigSep+is*smallSep
        sx1 = centerX + Math.cos(startAngle+curAng) * radiusExt
        sy1 = centerY + Math.sin(startAngle+curAng) * radiusExt
        if (curRpm <= lim-red) {
          hu('<line>', tacho.redline).attr({
            x1: last_sx1, y1: last_sy1,
            x2: sx1, y2: sy1,
            stroke: `rgba(255, 0, 0, 255)`, strokeWidth: 30
          })
        }
        last_sx1 = sx1
        last_sy1 = sy1
      }
    }

    tacho.ticksBlur.n.innerHTML = tacho.ticks.n.innerHTML
  }

  // overwriting plain javascript function so we can access from within the controller
  $window.setup = (data) => {
    if(!ready){
      console.log("calling setup while svg not fully loaded");
      setTimeout(function(){ $window.setup(data) }, 100);
      return;
    }
    redrawTachoTicks(data.maxRPM,1000,500,data.redRPM);
    redRPM = data.redRPM
  }

  $window.updateMode = (data) => {}

  $window.updateElectrics = (data) => {
    let speed = (UiUnits.speed(data.electrics.wheelspeed).val).toFixed(0)
    if (speed === "0") {
      electrics.speed[0].text("0").n.children[0].style.fill = electrics.speed.f0
      electrics.speed[1].text("0").n.children[0].style.fill = electrics.speed.f0
      electrics.speed[2].text("0").n.children[0].style.fill = electrics.speed.f0
    } else {
      switch(speed.length) {
        case 1:
          electrics.speed[0].text(speed[0]).n.children[0].style.fill = electrics.speed.f1
          electrics.speed[1].text("0").n.children[0].style.fill = electrics.speed.f0
          electrics.speed[2].text("0").n.children[0].style.fill = electrics.speed.f0
          break
        case 2:
          electrics.speed[0].text(speed[1]).n.children[0].style.fill = electrics.speed.f1
          electrics.speed[1].text(speed[0]).n.children[0].style.fill = electrics.speed.f1
          electrics.speed[2].text("0").n.children[0].style.fill = electrics.speed.f0

          break
        case 3:
          electrics.speed[0].text(speed[2]).n.children[0].style.fill = electrics.speed.f1
          electrics.speed[1].text(speed[1]).n.children[0].style.fill = electrics.speed.f1
          electrics.speed[2].text(speed[0]).n.children[0].style.fill = electrics.speed.f1
          break
      }
    }

    gauges.fuel.css({"transform":`rotateZ(${(1-data.electrics.fuel)*36}deg)`})
    gauges.temp.css({"transform":`rotateZ(${(1-(Math.max(data.electrics.watertemp-60,0)/60))*36}deg)`})
    gauges.power.css({"transform":`rotateZ(${(data.electrics.engineLoad)*36-36}deg)`})
    gauges.boost.css({"transform":`rotateZ(${(data.electrics.boost/data.electrics.boostMax)*36-36}deg)`})
    tacho.needle.css({"transform":`rotateZ(${data.electrics.rpmTacho*-rpmRatio*57.75}deg)`})

    if (data.electrics.rpmTacho > redRPM) {
      if (!flashing) {
        tacho.backgroundGradient.children[2].style.stopColor = "#ff0000"
        flashing = true
      }
    } else {
      if (flashing) {
        tacho.backgroundGradient.children[2].style.stopColor = "#0e162c"
        flashing = false
      }
    }

    for(var k in electrics.lights){
      electrics.lights[k].n.style.display = (data.electrics[k]===true || data.electrics[k]>0.1)?"inline":"none";
    }
    electrics.lights_watertemp.n.style.display = (data.electrics.watertemp > 110)?"inline":"none"

    block.css({display: data.electrics.ignitionLevel===0?"inline":"none"})
    boot.css({opacity: data.electrics.ignitionLevel===2?0:1})
  }

  $window.updateData = (data) => {
    if (typeof UiUnits === 'undefined') {
      setTimeout(function() { updateEconomyScreenLines() }, 300);
      return;
    }

    if (data) {
      if(!ready || !UiUnits){console.log("not ready");return;}

      tacho.root.css({"transform":`rotateZ(${data.electrics.steering}deg)`})
      updateGearIndicator(data);
      updateElectrics(data);
    }
  }
  //ready = true;
  //$window.updateConsum({current:0, average:0, range:0});
});