-- CREATED BY: JAMIE599
-- DATE: 2024/03/18
-- https://www.beamng.com/members/jamie599.152370/
-- Prototype version

local M = {}

local QUICK_CLICK_THRESHOLD = 0.2

local FLQuickPress = false
local FLPressValue = 0
local FLWindowPressTimer = 0
local FLWindowPressLast = 0
local LMoveSpeed = 0.3

local FRQuickPress = false
local FRPressValue = 0
local FRWindowPressTimer = 0
local FRWindowPressLast = 0
local RMoveSpeed = 0.3

local glassBroken = false
local jbeamDataCopy

local function reset()
    obj:queueGameEngineLua("extensions.load(\"openableWindowsJeskf\")")
    obj:queueGameEngineLua("openableWindowsJeskf.setup()")
    glassBroken = false

    electrics.values['LWindow'] = 0
    electrics.values['LWindowPress'] = 0
    electrics.values['LWindowGlow'] = 0
    FLWindowPressTimer = 0
    FLWindowPressLast = 0
    FLQuickPress = false
    FLPressValue = 0

    electrics.values['RWindow'] = 0
    electrics.values['RWindowPress'] = 0
    electrics.values['RWindowGlow'] = 0
    FRWindowPressTimer = 0
    FRWindowPressLast = 0
    FRQuickPress = false
    FRPressValue = 0
end

local function init(jbeamData)
    jbeamDataCopy = jbeamData
    LMoveSpeed = jbeamData.LMoveSpeed or LMoveSpeed
    RMoveSpeed = jbeamData.RMoveSpeed or RMoveSpeed
    reset()
end

local function updateGFX(dt)
    -- L Window
    if jbeamDataCopy.LOpenableWindowApplied then
        if electrics.values.LWindowPress ~= 0 and FLWindowPressLast == 0 then
            FLWindowPressTimer = QUICK_CLICK_THRESHOLD
            FLQuickPress = false
            FLPressValue = electrics.values.LWindowPress
        end

        if electrics.values.LWindowPress == 0 and FLWindowPressTimer ~= 0 and FLQuickPress == false and FLWindowPressLast ~= 0 then
            FLQuickPress = true
        end

        if electrics.values.LWindowPress ~= 0 or FLQuickPress then
            FLWindowPressTimer = FLWindowPressTimer - dt

            electrics.values.LWindow = clamp(electrics.values.LWindow + FLPressValue * LMoveSpeed * dt, -1, 0)

            if FLWindowPressTimer < 0 then
                FLWindowPressTimer = 0
            end
        end

        electrics.values.LWindowGlow = math.abs(electrics.values.LWindowPress)
        FLWindowPressLast = electrics.values.LWindowPress

    end

    -- R Window 
    if jbeamDataCopy.ROpenableWindowApplied then
        if electrics.values.RWindowPress ~= 0 and FRWindowPressLast == 0 then
            FRWindowPressTimer = QUICK_CLICK_THRESHOLD
            FRQuickPress = false
            FRPressValue = electrics.values.RWindowPress
        end

        if electrics.values.RWindowPress == 0 and FRWindowPressTimer ~= 0 and FRQuickPress == false and FRWindowPressLast ~= 0 then
            FRQuickPress = true
        end

        if electrics.values.RWindowPress ~= 0 or FRQuickPress then
            FRWindowPressTimer = FRWindowPressTimer - dt

            electrics.values.RWindow = clamp(electrics.values.RWindow + FRPressValue * RMoveSpeed * dt, -1, 0)

            if FRWindowPressTimer < 0 then
                FRWindowPressTimer = 0
            end
        end

        electrics.values.RWindowGlow = math.abs(electrics.values.RWindowPress)
        FRWindowPressLast = electrics.values.RWindowPress

    end

    if jbeamDataCopy.LOpenableWindowApplied or jbeamDataCopy.ROpenableWindowApplied then
        local maxOpen = math.min(electrics.values.LWindow, electrics.values.RWindow)
        if glassBroken then
            maxOpen = -1
        end
        obj:queueGameEngineLua(string.format("openableWindowsJeskf.handleAudio(" .. objectId .. ", %f)", clamp(1 - math.abs((maxOpen * 6)), 0, 1)))
    end
end

local function starts_with(str, prefix)
    return str:sub(1, #prefix) == prefix
end

local function beamDeformed(id, ratio)
    local beam = v.data.beams[id]

    if not beam or not beam.deformGroup then
        return
    end

    if not starts_with(beam.deformGroup, "doorglass") then
        return
    end

    glassBroken = true
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.beamBroken = beamBroken
M.beamDeformed = beamDeformed

return M
