local M = {}

M.type = "auxiliary"
M.messages = {
  engineOverheated = {
    translationIdText = "Regera.text.engineOverheat",
    translationIdCapital = "Regera.capital.engineOverheat",
	issued = false,
  },
  lowfuel = {
    translationIdText = "Regera.text.fuelLow",
    translationIdCapital = "Regera.capital.fuelLow",
	issued = false,
  },
  oiltemp = {
    translationIdText = "Regera.text.oiltemp",
    translationIdCapital = "Regera.capital.oiltemp",
	issued = false,
  },
  highBraketemp = {
    translationIdText = "Regera.text.highBrakeTemp",
    translationIdCapital = "Regera.capital.highBrakeTemp",
	issued = false,
  },
  watertemp = {
    translationIdText = "Regera.text.highTemp",
    translationIdCapital = "Regera.capital.highTemp",
	issued = false,
  },
  checkengine = {
    translationIdText = "Regera.text.mechanicalFault",
    translationIdCapital = "Regera.capital.mechanicalFault",
	issued = false,
  },
  oilLeak = {
    translationIdText = "Regera.text.oilLeak",
    translationIdCapital = "Regera.capital.oilLeak",
	issued = false,
  },
  lowTirePressure = {
    translationIdText = "Regera.text.lowTirePressure",
    translationIdCapital = "Regera.capital.lowTirePressure",
	issued = false,
  },
}

local userLang = "en-US"
local translations = jsonReadFile("/vehicles/regi/locales/en-US.json")

local issuedMessages = deepcopy(M.messages)
local gaugeHTMLTexture
local timer = 0
local currentWarning = false

local soundURL = ""
local soundNode = 0
local soundVolume = 0
local isInside = false

local driverNodeCid = 0
local camPos
local combinedPos
local function isCamInside()
  camPos = obj:getCameraPosition()
  isInside = combinedPos and (camPos:distance(combinedPos) <= 0.6) or false
  combinedPos = obj:getPosition() + obj:getNodePosition(driverNodeCid)
end

local function updateData(path)
end

local function updateGaugeData(moduleData, dt)
  isCamInside()
  if currentWarning then
    timer = timer + dt

    if timer > 7 then
      local data = { hide = true }
      gaugeHTMLTexture:streamJS("switchMessage", "switchMessage", data)
      currentWarning = false
    end
    return
  end
  M.messages["lowfuel"].issued = electrics.values.lowfuel == true
  M.messages["oiltemp"].issued = electrics.values.oiltemp > 150
  M.messages["watertemp"].issued = electrics.values.watertemp > 105
  M.messages["engineOverheated"].issued = electrics.values.watertemp > 125
  M.messages["lowTirePressure"].issued = (electrics.values.lowpressure == 1)
  M.messages["oilLeak"].issued = (electrics.values.oilLeak == 1)
  M.messages["highBraketemp"].issued = (electrics.values.highBraketemp == 1)
  M.messages["checkengine"].issued = (electrics.values.checkengineBetter == 1)

  for z,y in pairs(M.messages) do
    if y.issued == true and y.issued ~= issuedMessages[z].issued then
      local data = {
        messageCapital = translations[y.translationIdCapital] or y.translationIdCapital,
        messageText = translations[y.translationIdText] or y.translationIdText
      }
      if y.message2 then data.messageText2 = y.message2 end
      issuedMessages[z].issued = y.issued
	  
	  gaugeHTMLTexture:streamJS("switchMessage", "switchMessage", data)

      if isInside then
        obj:playSFXOnce("regiGaugeMessageWindow", soundNode, soundVolume, 1)
      end

      currentWarning = true
	  timer = 0
    elseif y.issued ~= issuedMessages[z].issued then
      issuedMessages[z].issued = y.issued
    end
  end
end

local function setupGaugeData(properties, htmlTexture)
  gaugeHTMLTexture = htmlTexture

  local data = { hide = true }
  gaugeHTMLTexture:streamJS("switchMessage", "switchMessage", data)
end

local function reset()
  local data = { hide = true }
  gaugeHTMLTexture:streamJS("switchMessage", "switchMessage", data)
  currentWarning = false

  for _,y in pairs(M.messages) do
    y.issued = false
  end
  issuedMessages = deepcopy(M.messages)

  userLang = settings.getValue("userLanguage") or "en-US"
  translations = jsonReadFile("/vehicles/regi/locales/"..(FS:fileExists("/vehicles/regi/locales/"..userLang..".json") and userLang or "en-US")..".json")
end

local function init(jbeamData)
  soundNode = beamstate.nodeNameMap[jbeamData.soundNode]
  driverNodeCid = beamstate.nodeNameMap["driver"]

  userLang = settings.getValue("userLanguage") or "en-US"
  translations = jsonReadFile("/vehicles/regi/locales/"..(FS:fileExists("/vehicles/regi/locales/"..userLang..".json") and userLang or "en-US")..".json")

  soundURL = jbeamData.soundEvent
  soundVolume = jbeamData.soundVolume or 1
end

local function initSounds()
  if soundURL then
    obj:createSFXSource(soundURL, "AudioDefault3D", "regiGaugeMessageWindow", -1)
  end
end

M.init = init
M.reset = reset
M.initSounds = initSounds

M.updateData = updateData
M.setupGaugeData = setupGaugeData
M.updateGaugeData = updateGaugeData

return M
