local M = {}
-- Убедимся, что таблица data и data.electrics инициализированы
data = data or {}
data.electrics = data.electrics or {}

-- Функция обновления значения throttle
local function updateThrottle()
    local throttleValue = electrics.values["throttle"] or 0 -- Получаем текущее значение throttle
    data.electrics.throttle = throttleValue -- Обновляем data.electrics.throttle
end

-- Добавляем событие обновления на каждом кадре
-- Если используется BeamNG API, регистрируем эту функцию для обновления

function onUpdate(dt)
    updateThrottle()
end

-- Подключаем функцию onUpdate к событию обновления
M.onUpdate = onUpdate

return M
