// RU Код создан: PoonJik (KDM | MODS) \ ENG Code to create: PoonJik (KDM | MODS)
// Элементы анимации
const hoodElement = document.getElementById('HoodSprite6');
const leftDoorElement = document.getElementById('leftDoorSprite5');
const rightDoorElement = document.getElementById('rightDoorSprite3');
const tailgateElement = document.getElementById('TailgateSprite2');
const bodyTwoElement = document.getElementById('BodySprite4');

// Состояния элементов
const states = {
  hood: 0, // 0 - закрыт, 1 - открыт
  leftDoor: 0,
  rightDoor: 0,
  tailgate: 0,
};

// Флаги для блокировки повторных анимаций
const animationInProgress = {
  hood: false,
  leftDoor: false,
  rightDoor: false,
  tailgate: false
};

// Общая функция для запуска анимации с callback
function toggleAnimation(element, isOpening, elementKey, callback) {
  // Если анимация уже выполняется для этого элемента, то ничего не делаем
  if (animationInProgress[elementKey]) return;

  // Проверяем, если анимация уже завершена в нужном состоянии, ничего не делаем
  if (isOpening && states[elementKey] === 1) return; // Уже открыто
  if (!isOpening && states[elementKey] === 0) return; // Уже закрыто

  // Устанавливаем флаг, что анимация началась
  animationInProgress[elementKey] = true;

  // Убираем текущую анимацию, если она есть
  element.classList.remove('sprite-animate');
  element.offsetWidth; // Принудительный перерендер

  // Устанавливаем направление анимации
  element.style.animationDirection = isOpening ? 'normal' : 'reverse';

  // Запускаем анимацию
  element.classList.add('sprite-animate');

  // Обновляем состояние после завершения анимации
  setTimeout(() => {
    // Обновляем состояние элемента
    states[elementKey] = isOpening ? 1 : 0;

    // Завершаем анимацию, сбрасывая флаг
    animationInProgress[elementKey] = false;

    // Вызываем callback, если он передан
    if (typeof callback === 'function') {
      callback();
    }
  }, 3000); // Время должно совпадать с `animation-duration` в CSS
}

// Управление анимацией капота
function openHood(callback) {
  toggleAnimation(hoodElement, true, 'hood', callback);
}
function closeHood(callback) {
  toggleAnimation(hoodElement, false, 'hood', callback);
}

// Управление анимацией левой двери
function openLeftDoor(callback) {
  toggleAnimation(leftDoorElement, true, 'leftDoor', callback);
}
function closeLeftDoor(callback) {
  toggleAnimation(leftDoorElement, false, 'leftDoor', callback);
}

// Управление анимацией правой двери
function openRightDoor(callback) {
  toggleAnimation(rightDoorElement, true, 'rightDoor', callback);
}
function closeRightDoor(callback) {
  toggleAnimation(rightDoorElement, false, 'rightDoor', callback);
}

// Управление анимацией багажника
function openTailgate(callback) {
  toggleAnimation(tailgateElement, true, 'tailgate', callback);
}
function closeTailgate(callback) {
  toggleAnimation(tailgateElement, false, 'tailgate', callback);
}

// Пример: обновление данных от BeamNG.Drive
function updateData(data) {
  if (data && data.electrics) {
    if (data.electrics.hoodLatchCoupler_notAttached === 1) {
      openHood(() => {
      });
    } else if (data.electrics.hoodLatchCoupler_notAttached === 0) {
      closeHood(() => {
      });
    }

    if (data.electrics.doorLCoupler_notAttached === 1) {
      openLeftDoor(() => {
      });
    } else if (data.electrics.doorLCoupler_notAttached === 0) {
      closeLeftDoor(() => {
      });
    }

    if (data.electrics.doorRCoupler_notAttached === 1) {
      openRightDoor(() => {
      });
    } else if (data.electrics.doorRCoupler_notAttached === 0) {
      closeRightDoor(() => {
      });
    }

    if (data.electrics.tailgateCoupler_notAttached === 1) {
      openTailgate(() => {
      });
    } else if (data.electrics.tailgateCoupler_notAttached === 0) {
      closeTailgate(() => {
      });
    }
  }
}

function setup(data) {
  updateData(data);
}

// Сброс анимации (например, при сбросе машины)
function resetAnimations() {
  // Сбрасываем все элементы в начальное положение
  [hoodElement, bodyTwoElement, leftDoorElement, rightDoorElement, tailgateElement].forEach((element) => {
    element.classList.remove('sprite-animate');
    element.style.animationDirection = 'normal';
    element.style.backgroundPositionY = '0px';
  });

  // Обновляем состояния
  Object.keys(states).forEach((key) => {
    states[key] = 0;
  });
  // Сбрасываем флаги анимации
  Object.keys(animationInProgress).forEach((key) => {
    animationInProgress[key] = false;
  });
}

// Пример привязки сброса
if (window && window.addEventListener) {
  window.addEventListener('resetVehicle', resetAnimations);
}
