-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local gear_A = 0
local gearIndex = 0

local function onInit()
  electrics.values['disp_P'] = 0
  electrics.values['disp_R'] = 0
  electrics.values['disp_Ra'] = 0
  electrics.values['disp_N'] = 0
  electrics.values['disp_Na'] = 0
  electrics.values['disp_1'] = 0
  electrics.values['disp_2'] = 0
  electrics.values['disp_3'] = 0
  electrics.values['disp_4'] = 0
  electrics.values['disp_5'] = 0
  electrics.values['disp_6'] = 0
  electrics.values['disp_7'] = 0
end

local function reset()
  onInit()
end

local function updateGFX(dt)
  gearIndex = electrics.values.gearIndex or 0
  gear_A = electrics.values['gear_A'] or 0

  -- Reverse Manual
  electrics.values['disp_R'] = (gearIndex < -0.5) and 1 or 0

  -- Neutral Manual
  electrics.values['disp_N'] = (gearIndex >= -0.5 and gearIndex < 0.5) and 1 or 0

  -- Gears 1 to 7
  electrics.values['disp_1'] = (gearIndex >= 0.5 and gearIndex < 1.5) and 1 or 0
  electrics.values['disp_2'] = (gearIndex >= 1.5 and gearIndex < 2.5) and 1 or 0
  electrics.values['disp_3'] = (gearIndex >= 2.5 and gearIndex < 3.5) and 1 or 0
  electrics.values['disp_4'] = (gearIndex >= 3.5 and gearIndex < 4.5) and 1 or 0
  electrics.values['disp_5'] = (gearIndex >= 4.5 and gearIndex < 5.5) and 1 or 0
  electrics.values['disp_6'] = (gearIndex >= 5.5 and gearIndex < 6.5) and 1 or 0
  electrics.values['disp_7'] = (gearIndex >= 6.5) and 1 or 0

  -- Park Auto
  electrics.values['disp_P'] = (gear_A < 0.05) and 1 or 0

  -- Reverse Auto
  electrics.values['disp_Ra'] = (gear_A >= 0.05 and gear_A < 0.15) and 1 or 0

  -- Neutral Auto
  electrics.values['disp_Na'] = (gear_A >= 0.15 and gear_A < 0.25) and 1 or 0

  -- Drive Auto (just remove display entirely or don't assign to disp_D)
  electrics.values['disp_D'] = 0 -- optional: delete this line entirely if `disp_D` is unused
end

-- public interface
M.onInit    = onInit
M.reset     = reset
M.updateGFX = updateGFX

return M
