local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

--Frix + ChatGPT for the general DRS logic
--Inn0centJok3r for the active downforce adjustment

local idlePosition = 0
local activatedPosition = 1 -- Spoiler activated position

local downforceLimitSpeed = 220 / 3.6 --speed in m/s, first value is the speed in km/h for easier adjustment
--The downforce speed limit will gradually decrease the wing angle at high speed to maintain a constant amount
--of downforce, ensuring the car does not bottom out

local spoilerFrontSmoother = newExponentialSmoothing(30)
local spoilerRearSmoother = newExponentialSmoothing(30)

local currentFrontPosition = activatedPosition
local currentRearPosition = activatedPosition

local targetFrontPosition = idlePosition
local targetRearPosition = idlePosition

local function updateGFX(dt)
	local wheelspeed = electrics.values.wheelspeed
    local brake = electrics.values.brake > 0.5 --minimum brake input for airbrake activation
    local isMoving = wheelspeed > 30 --airbrake activation speed

    if brake and isMoving then
		currentFrontPosition = spoilerFrontSmoother:get(activatedPosition)
		currentRearPosition = spoilerRearSmoother:get(activatedPosition)
		--reset DRS
		targetFrontPosition = activatedPosition
		targetRearPosition = activatedPosition
    else 
	--Difference factor between DRS and no DRS: 0,60  Speed at which DRS downforce = no DRS df @220: R 320km/h F 285km/h
	--Df @220 no DRS: 1.154  Df @220 DRS: 695
		if wheelspeed > downforceLimitSpeed then
			currentFrontPosition = spoilerFrontSmoother:get(clamp(0, 1 - clamp(0, 1, ((wheelspeed - downforceLimitSpeed) * 2.1) / downforceLimitSpeed), targetFrontPosition))
			currentRearPosition = spoilerRearSmoother:get(clamp(0, 1 - clamp(0, 1, ((wheelspeed - downforceLimitSpeed) * 2.5) / downforceLimitSpeed), targetRearPosition))
		else
			currentFrontPosition = spoilerFrontSmoother:get(targetFrontPosition)
			currentRearPosition = spoilerRearSmoother:get(targetRearPosition)
		end
	end

    -- Update spoiler positions
    electrics.values.spoilerF = 1 - currentFrontPosition
    electrics.values.spoilerR = 1 - currentRearPosition
end

local function clamp(min, max, val)
	if val < min then
		val = min
	elseif max < val then
		val = max
	end
	return val
end

local function reset(jbeamData)
    -- Reset to idle position
    currentFrontPosition = activatedPosition
    currentRearPosition = activatedPosition
	targetFrontPosition = activatedPosition
	targetRearPosition = activatedPosition
    electrics.values.spoilerF = activatedPosition
    electrics.values.spoilerR = activatedPosition
end

local function init(jbeamData)
    reset(jbeamData)
end

M.init = init
M.reset = reset
M.toggleSpoiler = toggleSpoiler -- Expose toggle function
M.updateGFX = updateGFX

return M
