angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;

    var speedoDisplay = { };
    var tacho = {  };
    var pages = {};
    var infoDisplay = {};
    var electrics = {lights:{}, dse:{} };
    var gagues = {page1:{},page2:{},page2_gmeter:{},page2_tires_pres:{},page2_tires_term:{},page2_text:{}};

    var currentGear = '';
    var cachedPage = {page1:false,page2:false};
    var refreshAng = 0.25*Math.PI/180;

    var ready = false;

    var units = {uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"};
    var unitspeedConv = 3.6;
    var rpmRatio = 0.1;

    function getNodesArray(prefix,number, root){
      let arr= [];
      for(let i=0;i<number;i++){
        let node = hu(prefix+i, root)
        if(!node)
          console.error(prefix+i,"node not found")
        else
          arr.push(node)
      }
      return arr;
    }

    function getRndInteger(min, max) {
      return Math.floor(Math.random() * (max - min) ) + min;
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[0].children[0];

      // speedometer
      speedoDisplay.root = hu('#speedometer', svg);
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root)
      speedoDisplay.speedValue = hu('#speed_val', svg);
      speedoDisplay.speedUnit = hu('#speed_unit', svg);
      speedoDisplay.gears = hu('#gear_txt', svg);

      tacho.markers_root = hu('#rpm_markers', svg);
      tacho.markers = getNodesArray("#rpm_markers_",21,tacho.markers_root)
      tacho.needle = hu('#needle', svg);


      electrics.odo_txt = hu("#odo_txt", svg);

      ready = true;
    }

    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        if(isNaN(data.electrics.gear)){//auto,DCT
            speedoDisplay.gears.text(data.electrics.gear);
        }else{//manuel
          switch(data.electrics.gear){
            case -1:
              speedoDisplay.gears.text("R");
              break;
            case 0:
              speedoDisplay.gears.text("N");
              break;
            default:
              speedoDisplay.gears.text(data.electrics.gear);
              break;
          }
        }
      }
    }

    function limitVal(min, val,max){
      return Math.min(Math.max(min,val), max);
    }
    function map_range(value, low1, high1, low2, high2) {
      return low2 + (high2 - low2) * (value - low1) / (high1 - low1);
    }
    const clamp = (num, min, max) => Math.min(Math.max(num, min), max);
    const clamp_remap = (val, min,max) => map_range(clamp(val,min,max), min,max,0,1);

    //https://stackoverflow.com/a/39077686
    const hexToRgb = hex =>
      hex.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i
                ,(m, r, g, b) => '#' + r + r + g + g + b + b)
        .substring(1).match(/.{2}/g)
        .map(x => parseInt(x, 16))
    const rgbParse = rgbStr => rgbStr.replace(/[^\d,]/g, '').split(',').map(Number);

    function updateTachoDisplays(data) {
      if (ready) {
        //106deg
        let angle = limitVal(-6350, data["electrics"]["rpmTacho"]-6100 , 6550) * 0.0221
        tacho.needle.n.style["transform"] = 'rotate('+angle+'deg)'
      }
    }



    function updateSpeedDisplays(data) {
      if (ready) {
        speedoDisplay.speedValue.text((data.electrics.wheelspeed*unitspeedConv).toFixed(0))
      }
    }



    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);
      for(let dk in data){
        if(typeof dk == "string" && dk.startsWith("uiUnit")){
          units[dk] = data[dk];
        }
      }
      vueEventBus.emit('SettingsChanged', {values:units})

      if(units.uiUnitLength == "metric"){
        speedoDisplay.speedUnit.text("KMH");
        unitspeedConv = 3.6;
      }
      else{
        speedoDisplay.speedUnit.text("MPH");
        unitspeedConv = 2.23694;
      }

    }




    //https://stackoverflow.com/a/56266358
    function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    $window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      //error checking because we can't trust people we work with
      /*if(data === null
      || data === undefined
      || data.modeName === null
      || data.modeName === undefined
      || typeof data.modeName !== "string"
      || data.modeColor === null
      || data.modeColor === undefined
      || typeof data.modeColor !== "string"){
        console.error("updateMode receive wrong arguments :", data);
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "MODE";
        return;
      }
      if(!isColor(data.modeColor)){
        console.error("This mode color is not in html format :",data.modeColor)
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "COL";
        return;
      }*/

      //hex color without # works in html but not in svg BECAUSE
      let s = new Option().style;
      s.color = data.modeColor;
      data.modeColor = s.color;

      electrics.mode_txt.text(data.modeName).css({"fill": data.modeColor});

      let rgb = rgbParse(data.modeColor)
      electrics.backgroundFilter.attr({values: (rgb[0]/255).toFixed(2)+" 0 0 0 0 0 "+(rgb[1]/255).toFixed(2)+" 0 0 0 0 0 "+(rgb[2]/255).toFixed(2)+" 0 0 0 0 0 1 0"})

      $window.setDSELights(data.dseLights)
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
         //console.log(data);

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        updateSpeedDisplays(data);
        updateTachoDisplays(data);


        $window.setRpmMarker(data.customModules.dynamicRedlineData)


        //if (pages.page2_gmeter.n.style.display === "inline" && cachedPage.page2=="gmeter") {
        //  updateAccelerometer(data);
        //}

        if(cachedPage.page1){

        }

      }
    }

    $window.setRpmMarker = (data) => {
      if(!ready){
        console.log("calling setRpmMarker while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }
      if(!data)return;

      //tacho.markers_root.css({filter:(data.shiftLight)?"url(#filterRedline)":""})
      //tacho.markers_root.css({animation:(data.shiftLight)?"blinkRedLine 0.25s linear infinite":""})

      for(let i=0;i<tacho.markers.length;i++){
        if(i>= data.red)
          tacho.markers[i].css({stroke:"#f00",animation:(data.shiftLight)?"blinkRedLine 0.25s linear infinite":""})
        else{
          if(i<data.yellow)
            tacho.markers[i].css({stroke:"#fff", animation:(data.shiftLight)?"blinkRedLine 0.25s linear infinite":""})
          else
            tacho.markers[i].css({stroke:"#ffd700", animation:(data.shiftLight)?"blinkRedLine 0.25s linear infinite":""})
        }
      }
    }




    let demoStep = 0;

    function getRndFloat(min, max) {
      return Math.random() * (max - min) + min;
    }

    function getRndColor() {
      return "#" + Math.floor(Math.random()*16777215).toString(16);;
    }

    function demo(){
      switch(demoStep){
        case 0:
          setPage("time");
          break;
        case 1:
          setPage("gmeter");
          break;
        case 2:
          setPage("tires");
          break;
        case 3:
          setPage("text");
          break;
        case 4:
          setPage("nope");
          break;
      }

      demoStep = (demoStep+1)%4
      demoStep=0

      setRpmMarker({yellow:16,red:18,redLine:(Math.random()>0.5 && false)})

      //setDSELights({esc:getRndColor(),tcs:getRndColor(),powertrain:getRndColor(),suspension:getRndColor()})

      updateData({electrics: {rpmTacho: getRndInteger(0,10000), engineRunning:Math.random()*0.2, odometer:Math.random()*50000000 },
        customModules: {
          accelerationData: {xSmooth:getRndFloat(-20,20) ,ySmooth:getRndFloat(-20,20)},

          dynamicRedlineData:{yellow:12,red:14,shiftLight:false},

          combustionEngineData:{fuelDisplay:Math.random()*50,averageFuelConsumption:Math.random()*50,currentFuelConsumption:Math.random()*50,remainingRange:Math.random()*200}
        }});

      setTimeout(demo, 2000);
    }
    if(typeof beamng == 'undefined' || typeof beamng.sendActiveObjectLua == 'undefined') { //mode demo only in external browser
      console.log("Demo mode")
      setTimeout(()=>{
        setDSELights({esc:getRndColor(),tcs:getRndColor(),powertrain:getRndColor(),suspension:getRndColor()})
        updateMode({modeName:"TEST DEMO", modeColor:"#F60"});
        demo()
      }, 500);
    }
    //ready = true;
  });
