
--██████╗░░█████╗░██╗░░░██╗░█████╗░██╗░░░░░
--██╔══██╗██╔══██╗╚██╗░██╔╝██╔══██╗██║░░░░░
--██████╔╝██║░░██║░╚████╔╝░███████║██║░░░░░
--██╔══██╗██║░░██║░░╚██╔╝░░██╔══██║██║░░░░░
--██║░░██║╚█████╔╝░░░██║░░░██║░░██║███████╗
--╚═╝░░╚═╝░╚════╝░░░░╚═╝░░░╚═╝░░╚═╝╚══════╝

--██████╗░███████╗███╗░░██╗██████╗░███████╗██████╗░██╗███╗░░██╗░██████╗░░██████╗
--██╔══██╗██╔════╝████╗░██║██╔══██╗██╔════╝██╔══██╗██║████╗░██║██╔════╝░██╔════╝
--██████╔╝█████╗░░██╔██╗██║██║░░██║█████╗░░██████╔╝██║██╔██╗██║██║░░██╗░╚█████╗░
--██╔══██╗██╔══╝░░██║╚████║██║░░██║██╔══╝░░██╔══██╗██║██║╚████║██║░░╚██╗░╚═══██╗
--██║░░██║███████╗██║░╚███║██████╔╝███████╗██║░░██║██║██║░╚███║╚██████╔╝██████╔╝
--╚═╝░░╚═╝╚══════╝╚═╝░░╚══╝╚═════╝░╚══════╝╚═╝░░╚═╝╚═╝╚═╝░░╚══╝░╚═════╝░╚═════╝░

--█▀▄ █▀█   █▄░█ █▀█ ▀█▀   █░█ █▀ █▀▀   █░█░█ █ ▀█▀ █░█ █▀█ █░█ ▀█▀   █▀█ █▀▀ █▀█ █▀▄▀█ █ █▀ █▀ █ █▀█ █▄░█
--█▄▀ █▄█   █░▀█ █▄█ ░█░   █▄█ ▄█ ██▄   ▀▄▀▄▀ █ ░█░ █▀█ █▄█ █▄█ ░█░   █▀▀ ██▄ █▀▄ █░▀░█ █ ▄█ ▄█ █ █▄█ █░▀█

local M = {}
M.type = "auxiliary"

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil
local textureWidth = 800
local textureHeight = 160
local textureFPS = 30

local updateTimer = 0
local invFPS = 1 / 50

local ledPressureMap = {
    -30, -24, -18, -12, -6, 0,
    2, 4, 6, 8, 10, 12, 14, 16,
    18, 20, 22, 24, 26, 28, 30,
    32, 33, 35
}

local currentBoostPsi = 0

local function calculateBoostPressure()
    local boostPsi = electrics.values.turboBoost or electrics.values.boost or 0
    return math.max(-30, math.min(35, boostPsi))
end

local function updateLEDs(pressurePsi)
    for i = 1, 24 do
        electrics.values["aem_led" .. i] = 0
    end
    for i = 1, 24 do
        if pressurePsi >= ledPressureMap[i] then
            electrics.values["aem_led" .. i] = 1
        end
    end
end

local function init(jbeamData)
    if jbeamData then
        screenMaterialName = jbeamData.screenMaterialName
        htmlFilePath = jbeamData.htmlFilePath
        textureWidth = jbeamData.textureWidth or 800
        textureHeight = jbeamData.textureHeight or 160
        textureFPS = jbeamData.textureFPS or 30
    end
    
    if screenMaterialName and htmlFilePath then
        htmlTexture.create(screenMaterialName, htmlFilePath, textureWidth, textureHeight, textureFPS, "automatic")
    end
    
    for i = 1, 24 do
        electrics.values["aem_led" .. i] = 0
    end
    
    electrics.values.aem_boost_psi = 0
end

local function updateGFX(dt)
    updateTimer = updateTimer + dt
    
    if updateTimer > invFPS then
        updateTimer = 0
        
        local ignitionLevel = electrics.values.ignitionLevel or 0
        
        if ignitionLevel <= 0 then
            for i = 1, 24 do
                electrics.values["aem_led" .. i] = 0
            end
            electrics.values.aem_boost_psi = 0
            electrics.values.aem_boost_bar = 0
            electrics.values.aem_boost_kpa = 0
            
            if screenMaterialName then
                htmlTexture.call(screenMaterialName, "updateFromVehicle", {
                    boostPsi = 0,
                    running = false
                })
            end
        else
            currentBoostPsi = calculateBoostPressure()
            updateLEDs(currentBoostPsi)
            
            electrics.values.aem_boost_psi = currentBoostPsi
            electrics.values.aem_boost_bar = currentBoostPsi * 0.0689476
            electrics.values.aem_boost_kpa = currentBoostPsi * 6.89476
            
            if screenMaterialName then
                htmlTexture.call(screenMaterialName, "updateFromVehicle", {
                    boostPsi = currentBoostPsi,
                    running = electrics.values.running or false
                })
            end
        end
    end
end

local function onReset()
    updateTimer = 0
    currentBoostPsi = 0
    
    for i = 1, 24 do
        electrics.values["aem_led" .. i] = 0
    end
    
    electrics.values.aem_boost_psi = 0
end

local function onDestroy()
    if screenMaterialName then
        htmlTexture.destroy(screenMaterialName)
    end
end

M.init = init
M.updateGFX = updateGFX
M.onReset = onReset
M.onDestroy = onDestroy

return M