-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local function onReset()
    electrics.values['dsbar'] = 0
end

local function updateGFX(dt)
    local open = electrics.values['open_input'] or 0
    local close = electrics.values['close_input'] or 0
    local openclose = electrics.values['openclose_input'] or 0
    local speed = math.max(-1,math.min(1, openclose + close - open))
    local target = math.max(-1, math.min(1, electrics.values['dsbar'] + (speed * dt * 0.1)))
    electrics.values['dsbar'] = target
end

-- public interface
M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M
