-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local clamp = clamp
local ball_43
local ball_42
local cannon_14
local cannon_9

local cooldown
local lastCheckedFireValue -- allows using an input device axis as shooting control, not just on/off buttons



function updateOpen(input, currentValue, dt)
  return clamp((currentValue + input * dt), -1, 0)
end
local function onReset()
  electrics.values['openWindowFR'] = 0
  electrics.values['open_window_FR_input'] = 0
  electrics.values['openR'] = 0
  electrics.values['open_kozy_r_input'] = 0
   electrics.values['openL'] = 0
  electrics.values['open_kozy_l_input'] = 0
    electrics.values['openWindowFL'] = 0
  electrics.values['open_window_FL_input'] = 0
    electrics.values['openWindowRL'] = 0
  electrics.values['open_window_RL_input'] = 0
    electrics.values['openWindowRR'] = 0
  electrics.values['open_window_RR_input'] = 0
  electrics.values['lifter'] = 0
  electrics.values['lifter_input'] = 0
  electrics.values['shoot'] = 0
  cooldown = 0
  lastCheckedFireValue = 0
  for k, node in pairs (v.data.nodes) do
    if node.name == "ball_43" then ball_43=k  end
    if node.name == "ball_42" then ball_42=k  end
    if node.name == "cannon_14" then cannon_14=k  end
    if node.name == "cannon_9" then cannon_9=k  end
  end
end

local function updateGFX(dt)
  if electrics.values.open_kozy_l_input ~= 0 then electrics.values.openL = updateOpen(electrics.values.open_kozy_l_input, electrics.values.openL, 0.55*dt) end
  if electrics.values.open_kozy_r_input ~= 0 then electrics.values.openR = updateOpen(electrics.values.open_kozy_r_input, electrics.values.openR, 0.55*dt) end
    if electrics.values.open_window_FR_input ~= 0 then electrics.values.openWindowFR = updateOpen(electrics.values.open_window_FR_input, electrics.values.openWindowFR, 0.355*dt) end
    if electrics.values.open_window_FL_input ~= 0 then electrics.values.openWindowFL = updateOpen(electrics.values.open_window_FL_input, electrics.values.openWindowFL, 0.355*dt) end
    if electrics.values.open_window_RL_input ~= 0 then electrics.values.openWindowRL = updateOpen(electrics.values.open_window_RL_input, electrics.values.openWindowRL, 0.355*dt) end
    if electrics.values.open_window_RR_input ~= 0 then electrics.values.openWindowRR = updateOpen(electrics.values.open_window_RR_input, electrics.values.openWindowRR, 0.355*dt) end
	  electrics.values['lifter'] = math.min(1, math.max(-0.0, (electrics.values['lifter'] + electrics.values['lifter_input'] * dt * 0.2)))
  if electrics.values['shoot'] == 1 then
    if math.random(0, 500) < (500-cooldown*1000) then -- cannon smoke & fire for 500 ms
      obj:addParticleByNodesRelative(cannon_14, cannon_9, 5, 49, 1, 10)
      obj:addParticleByNodesRelative(cannon_14, cannon_9, 5, 29, 1, 10)
      obj:addParticleByNodesRelative(cannon_14, cannon_9, 5, 37, 1, 10)
    end
    cooldown = cooldown + dt
  end
	end

local function open_kozy_R(value) electrics.values.open_kozy_r_input = -value end
local function close_kozy_R(value) electrics.values.open_kozy_r_input = value end
local function open_kozy_L(value) electrics.values.open_kozy_l_input = -value end
local function close_kozy_L(value) electrics.values.open_kozy_l_input = value end
local function open_window_FR(value) electrics.values.open_window_FR_input = -value end
local function close_window_FR(value) electrics.values.open_window_FR_input = value end
local function open_window_FL(value) electrics.values.open_window_FL_input = -value end
local function close_window_FL(value) electrics.values.open_window_FL_input = value end
local function open_window_RL(value) electrics.values.open_window_RL_input = -value end
local function close_window_RL(value) electrics.values.open_window_RL_input = value end
local function open_window_RR(value) electrics.values.open_window_RR_input = -value end
local function close_window_RR(value) electrics.values.open_window_RR_input = value end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.open_kozy_R = open_kozy_R
M.close_kozy_R = close_kozy_R
M.open_kozy_L = open_kozy_L
M.close_kozy_L = close_kozy_L
M.open_window_FR = open_window_FR
M.close_window_FR = close_window_FR
M.open_window_FL = open_window_FL
M.close_window_FL = close_window_FL
M.open_window_RL = open_window_RL
M.close_window_RL = close_window_RL
M.open_window_RR = open_window_RR
M.close_window_RR = close_window_RR

local function fire(VALUE)
  if VALUE < 0.9 then
    -- axis/button is not being pressed down far enough, ignore this event
    lastCheckedFireValue = VALUE
    return
  end
  if lastCheckedFireValue >= 0.9 then return end -- ignore consecutive events after we have passed the 90% threshold: only process the first event of them all
  if VALUE < lastCheckedFireValue then return end -- ignore event if user is in the process of releasing the button/axis (even when above firing threshold)

  lastCheckedFireValue = VALUE
  if electrics.values['shoot'] == 1 then
    -- notify the user *only once* via gui.message
    gui.message("Cannon ball was already fired")
    return
  end

  electrics.values['shoot'] = 1 -- trigger actual shooting via thruster
  
  obj:queueGameEngineLua("extensions.hook('onCannonFired'," .. obj:getID() .. ")")
end

local function liftBarrel(value)
  electrics.values.lifter_input = value
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.fire      = fire
M.liftBarrel = liftBarrel


return M
