-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['hook'] = 0
  electrics.values['hook_input'] = 0
end

local function updateGFX(dt) -- ms
  electrics.values['hook'] = math.min(1, math.max(-0.0, (electrics.values['hook'] + electrics.values['hook_input'] * dt * 0.25)))
end

local function moveHook(value)
  electrics.values.hook_input = value
end


-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.moveHook = moveHook

return M
