-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

--round from http://lua-users.org/wiki/SimpleRound


local M = {}

local gear, water, fuel, fuelt, oil, led_off1
local curWheel

local unitVel = 3.6
local unitVol = 1
local unitTemp = 1
local unitTemp1 = 0

local brakeFL, brakeFR, brakeRL, brakeRR

local vehicleID = obj:getID()
local dashScreenName = "@FR17_screen2"


local function round(num, idp)
	if num then
		local mult = 10^(idp or 0)
		return math.floor(num * mult + 0.5) / mult
	else
		return 0
	end
end



local function runFunc(func)
	obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..dashScreenName.."', '"..func.."') end")
end





local function onInit()
		obj:queueGameEngineLua("extensions.loadModule('ui/uinavi')")
		obj:queueGameEngineLua('be:getObjectByID('..vehicleID..'):createUITexture("'..dashScreenName..'", "local://local/vehicles/bmwe46/dashc.html", 1024, 512, UI_TEXTURE_USAGE_AUTOMATIC, 30)')
		
end

local function updateGFX(dt)
		
		gear = math.floor(electrics.values.gearIndex + 0.5)
		water = math.floor((electrics.values.watertemp * unitTemp + unitTemp1) + 0.5)
		oil = math.floor((electrics.values.oiltemp * unitTemp + unitTemp1) + 0.5)
		fuel = math.floor(electrics.values.fuelVolume * unitVol + 0.5)
		fuelt = math.floor(60)
		
		led_off1 = electrics.values["led_off1"]

		brakeFL = math.floor((wheels.wheels[wheels.wheelIDs.FL].brakeCoreTemperature * unitTemp + unitTemp1) + 0.5)
		brakeFR = math.floor((wheels.wheels[wheels.wheelIDs.FR].brakeCoreTemperature * unitTemp + unitTemp1) + 0.5)
		brakeRL = math.floor((wheels.wheels[wheels.wheelIDs.RL].brakeCoreTemperature * unitTemp + unitTemp1) + 0.5)
		brakeRR = math.floor((wheels.wheels[wheels.wheelIDs.RR].brakeCoreTemperature * unitTemp + unitTemp1) + 0.5)
		
		
		
		runFunc("updateGear("..gear..")")
		runFunc("updateWater("..water..")")
		runFunc("updateOil("..oil..")")
		runFunc("updateFuel("..fuel..")")
		runFunc("updateFuelt("..fuelt..")")
		runFunc("updateled_off1("..led_off1..")")
		runFunc("updateBrakes("..brakeFL..","..brakeFR..","..brakeRL..","..brakeRR..")")
			
	
end

-- public interface
M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M
