-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local refHydros = {
    roof = "rf_roof_reference",
    tonneau = "rf_tonneau_reference",
    glass = "rf_glass_reference"
}

local roofMotionState = 0
local tonneauSmoother = newTemporalSigmoidSmoothing(0.7, 0.2, 0.2, 0.7, 0)
local roofSmoother = newTemporalSigmoidSmoothing(0.4, 0.05, 0.05, 0.4, 0)
local glassSmoother = newTemporalSigmoidSmoothing(0.5, 0.65, 0.65, 0.5, 0)
local tonneauTargetValue = 0
local roofTargetValue = 0
local glassValueOverwrite = 0
local glassInMovement = false
local glassValue = 0
local direction = "open"

local whirrLoop = 0

local function getHydroState(cid)
    return v.data.hydros[cid].state
end

local function roofMovementFinish()
    roofMotionState = 0
    electrics.values.roofMoving = 0
    obj:playSFXOnceCT("event:>Vehicle>Latches>Hood>modern_07_open_hood", v.data.refNodes[0].ref, 2, 0.5, 0.4, 0)
    obj:stopSFX(whirrLoop)
end

local function openMovement()
    local tonneauValue = getHydroState(refHydros.tonneau)
    local tonneauOpen = tonneauValue > 4
    local roofOpen = getHydroState(refHydros.roof) < 0.55

    if roofMotionState == 1 then
        if tonneauOpen then
            roofTargetValue = 1
            roofMotionState = roofOpen and 2 or roofMotionState
        end
    elseif roofMotionState == 2 then
        tonneauTargetValue = 0

        -- this is terrible, but occasionally beamng decides that 1 isn't actually 1 and so it gets stuck here
        if tostring(tonneauValue) == "1" then
            roofMovementFinish()
        end
    end
end

local function closeMovement()
    local tonneauValue = getHydroState(refHydros.tonneau)
    local tonneauOpen = tonneauValue > 4
    local roofClosed = getHydroState(refHydros.roof) > 0.95

    if roofMotionState == 1 then
        if tonneauOpen then
            roofTargetValue = 0
            roofMotionState = roofClosed and 2 or roofMotionState
        end
    elseif roofMotionState == 2 then
        tonneauTargetValue = 0
        if tostring(tonneauValue) == "1" then
            glassValueOverwrite = 0
            glassValue = glassValueOverwrite
            controller.getControllerSafe("windowR").setValue(glassValueOverwrite)
            controller.getControllerSafe("windowL").setValue(glassValueOverwrite)
            glassInMovement = true
            roofMovementFinish()
        end
    end
end

local function updateGFX(dt)
    if glassInMovement then
        electrics.values.toggle_RFglass = glassSmoother:get(glassValue, dt)
        if (glassValue == 0 and electrics.values.toggle_RFglass == 0) or (glassValue == 1 and electrics.values.toggle_RFglass == 1) then
            glassInMovement = false
        end
    end

    if roofMotionState == 0 then return end

    electrics.values.toggle_RFroof = roofSmoother:get(roofTargetValue, dt)
    electrics.values.toggle_RFtonneau = tonneauSmoother:get(tonneauTargetValue, dt)

    local volume = math.abs(roofSmoother.prevvel)*0.9+math.abs(tonneauSmoother.prevvel)*0.65
    local pitch = math.abs(roofSmoother.prevvel)*0.2+math.abs(tonneauSmoother.prevvel)*0.45 +1.35
    obj:setVolumePitch(whirrLoop, volume, pitch)

    if direction == "open" then
        openMovement()
    else
        closeMovement()
    end
end

local function startRoofAction()
    if roofMotionState ~= 0 then
        guihooks.message("Please wait for the roof to completely open/close.", 2, "vehicle.rfroof.canttoggle")
        return
    end

    if electrics.values.wheelspeed > 2.68224 then
        guihooks.message("The roof cannot be toggled above 6mph (10km/h).", 2, "vehicle.rfroof.canttoggle")
        return
    end

    controller.getController("roofOpen").toggleGroup()

    if getHydroState(refHydros.roof) < 0.55 then
        tonneauTargetValue = 1
        roofTargetValue = 1
        direction = "close"
        guihooks.message("The roof is now closing.", 15, "vehicle.rfroof.toggled")
        electrics.values.roofMoving = 2
    else
        tonneauTargetValue = 1
        roofTargetValue = 0
        glassValueOverwrite = 1
        glassValue = glassValueOverwrite
        controller.getControllerSafe("windowR").setValue(glassValueOverwrite)
        controller.getControllerSafe("windowL").setValue(glassValueOverwrite)
        glassInMovement = true
        --electrics.values.toggle_RFglass = glassValueOverwrite
        direction = "open"
        guihooks.message("The roof is now opening.", 15, "vehicle.rfroof.toggled")
        electrics.values.roofMoving = 1
    end

    obj:playSFXOnceCT("event:>Vehicle>Latches>Hood>modern_06_open_hood", v.data.refNodes[0].ref, 1, 0.5, 0.1, 0)
    obj:playSFX(whirrLoop)

    roofMotionState = 1
end

local function windowToggle()
    if glassValueOverwrite == 1 then
        guihooks.message("Please close the roof before trying to close the window.", 2, "vehicle.rfroof.canttoggle")
        return
    end
    glassInMovement = true
    glassValue = 1-glassValue
    --electrics.values.toggle_RFglass = 1-(electrics.values.toggle_RFglass or 0)
end

local function initSounds()
    whirrLoop = obj:createSFXSource2("/vehicles/ccf/art/sound/electric_whirr.ogg", "AudioDefaultLoop3D", "roofWhirrLoop", v.data.hydros[refHydros.tonneau].id1, 0)
end

local function init()
    for i=0, tableSizeC(v.data.hydros)-1 do
        local v = v.data.hydros[i]

        if not v.tag then goto skip end
        for k,v2 in pairs(refHydros) do
            if v2 ~= v.tag then goto skip2 end
            refHydros[k] = v.cid
            ::skip2::
        end
        ::skip::
    end

    electrics.values.toggle_RFtonneau = 0
    electrics.values.toggle_RFroof = 0
    electrics.values.toggle_RFglass = 0
    electrics.values.roofMoving = 0
end

local function reset()
    roofMotionState = 0
    tonneauTargetValue = 0
    roofTargetValue = 0
    glassValueOverwrite = 0
    roofSmoother:set(0)
    tonneauSmoother:set(0)
    electrics.values.toggle_RFtonneau = 0
    electrics.values.toggle_RFroof = 0
    electrics.values.toggle_RFglass = 0
    electrics.values.roofMoving = 0
end

M.initSounds = initSounds
M.windowToggle = windowToggle
M.startRoofAction = startRoofAction
M.updateGFX = updateGFX
M.init = init
M.reset = reset

return M