-- written by DaddelZeit

local M = {}

local leftIsOn = false
local rightIsOn = false

local corneringDataL = {}
local corneringDataR = {}

local corneringSmootherL = newExponentialSmoothingT(30)
local corneringSmootherR = newExponentialSmoothingT(30)

local fadeValR = 0
local fadeValL = 0

local function updateGFX(dt)
    if ((electrics.values.wheelspeed > 13.4 and electrics.values.wheelspeed < 0.1) and (electrics.values.signal_left_input == 0 and electrics.values.signal_right_input == 0)) or electrics.values.lowhighbeam == 0 then
        leftIsOn = false
        rightIsOn = false
    else
        rightIsOn = electrics.values.steering < -70 or (electrics.values.signal_right_input == 1 and electrics.values.wheelspeed < 8.333 and electrics.values.hazard_enabled == 0)
        leftIsOn = electrics.values.steering > 70 or (electrics.values.signal_left_input == 1 and electrics.values.wheelspeed < 8.333 and electrics.values.hazard_enabled == 0)
    end

    fadeValL = corneringSmootherL:get(leftIsOn and 1 or 0)
    fadeValR = corneringSmootherR:get(rightIsOn and 1 or 0)

    electrics.values.cornering_L = fadeValL > 0.025
    electrics.values.cornering_R = fadeValR > 0.025

    if corneringDataL.propIndex and corneringDataR.propIndex then
        obj:queueGameEngineLua(
            " scenetree.findObjectById("..obj:getId().."):getProp("..corneringDataL.propIndex.."):getLight():setLightArgs("
            ..corneringDataL.innerAngle..", "
            ..corneringDataL.outerAngle..", "
            ..(fadeValL/(1/corneringDataL.maxBrightness)/100)..", "
            ..corneringDataL.range..", "
            .."ColorF("..corneringDataL.color.r..","..corneringDataL.color.g..","..corneringDataL.color.b..","..corneringDataL.color.a.."), "
            .."vec3("..corneringDataL.attenuation.x..","..corneringDataL.attenuation.y..","..corneringDataL.attenuation.y.."), "
            ..corneringDataL.castShadows..") "

            ..

            " scenetree.findObjectById("..obj:getId().."):getProp("..corneringDataR.propIndex.."):getLight():setLightArgs("
            ..corneringDataR.innerAngle..", "
            ..corneringDataR.outerAngle..", "
            ..(fadeValR/(1/corneringDataR.maxBrightness)/100)..", "
            ..corneringDataR.range..", "
            .."ColorF("..corneringDataR.color.r..","..corneringDataR.color.g..","..corneringDataR.color.b..","..corneringDataR.color.a.."), "
            .."vec3("..corneringDataR.attenuation.x..","..corneringDataR.attenuation.y..","..corneringDataR.attenuation.y.."), "
            ..corneringDataR.castShadows..") "
        )
    end
end

local function init()
    for _,v in pairs(v.data.props) do
        if v.mesh == "SPOTLIGHT" then
            if v.func == "cornering_L" then
                corneringDataL.propIndex = v.cid
                corneringDataL.maxBrightness = v.lightBrightness
                corneringDataL.innerAngle = v.lightInnerAngle
                corneringDataL.outerAngle = v.lightOuterAngle
                corneringDataL.range = v.lightRange
                corneringDataL.color = v.lightColor
                corneringDataL.attenuation = vec3(v.lightAttenuation)
                corneringDataL.castShadows = tostring(v.lightCastShadows)
            elseif v.func == "cornering_R" then
                corneringDataR.propIndex = v.cid
                corneringDataR.maxBrightness = v.lightBrightness
                corneringDataR.innerAngle = v.lightInnerAngle
                corneringDataR.outerAngle = v.lightOuterAngle
                corneringDataR.range = v.lightRange
                corneringDataR.color = v.lightColor
                corneringDataR.attenuation = vec3(v.lightAttenuation)
                corneringDataR.castShadows = tostring(v.lightCastShadows)
            end
        end
    end

    leftIsOn = false
    rightIsOn = false
end

M.reset = init
M.init = init
M.updateGFX = updateGFX

return M