-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"

local soundNode1
local soundNode2
local soundNode3
local frontCouplers
local rearCouplers
local coverCouplers

local roofUnlatchingTimer = 0
local roofHidingTimer = 0
local roofClosingTimer = 0
local roofLatchingTimer = 0
local roofClosed = true
local roofOpen = false
local roofBroken = false

--adjustable
local roofUnlatchingTime = 3 --seconds
local roofHidingTime = 9 --seconds
local roofClosingTime = 10 --seconds
local roofLatchingTime = 1 --seconds
local latchSound = "event:>Vehicle>Latches>Special>beambox_close"
local unlatchSound = "event:>Vehicle>Latches>Special>beambox_open"


local function updateGFX(dt)

    --open/close roof stage 1
    if electrics.values.toggle_roof == 1 then
        electrics.values.toggle_roof = 0
        if roofBroken then
            guihooks.message("Roof broken, cannot operate", 3, convertibleRoof)
            return
        end
        if roofUnlatchingTimer > 0 or roofHidingTimer > 0 then
            guihooks.message("Please wait until roof finishes opening", 3, convertibleRoof)
        end
        if roofLatchingTimer > 0 or roofClosingTimer > 0 then
            guihooks.message("Please wait until roof finishes closing", 3, convertibleRoof)
        end

        --open
        if roofClosed then
            if electrics.values.sidewindows_down == 0 then
                guihooks.message("Roll down the side windows first before opening the roof", 3, convertibleRoof)
            else
                roofClosed = false
                beamstate.detachCouplers('rooflatch_l', true)
                beamstate.detachCouplers('rooflatch_r', true)
                beamstate.detachCouplers('rooflatchr_l', true)
                beamstate.detachCouplers('rooflatchr_r', true)
                if roofUnlatchingTimer <= 0 and not roofOpen  then
                    roofUnlatchingTimer = roofUnlatchingTime
                end
            end

        --close
        elseif roofOpen then
            if electrics.values.sidewindows_down == 0 then
                guihooks.message("Roll down the side windows first before closing the roof", 3, convertibleRoof)
            else
                roofOpen = false
                beamstate.detachCouplers('klapkalatch', true)
                electrics.values.roof_position = 0
                if roofClosingTimer <= 0 and not roofClosed  then
                    roofClosingTimer = roofClosingTime
                end
            end
        end
    end

    --open roof stage 2
    if roofUnlatchingTimer > 0 then
        roofUnlatchingTimer = roofUnlatchingTimer - dt
        if roofUnlatchingTimer < 0 then
            roofUnlatchingTimer = 0
            electrics.values.roof_position = 1
            beamstate.detachCouplers('klapkalatch', true)
            if roofHidingTimer <= 0 then
                roofHidingTimer = roofHidingTime
            end
        end
    end

    --open roof stage 3
    if roofHidingTimer > 0 then
        roofHidingTimer = roofHidingTimer - dt
        if roofHidingTimer < 0 then
            roofHidingTimer = 0
            beamstate.attachCouplers('klapkalatch')
            roofOpen = true
        end
    end

    --close roof stage 2
    if roofClosingTimer > 0 then
        roofClosingTimer = roofClosingTimer - dt
        if roofClosingTimer < 0 then
            roofClosingTimer = 0
            beamstate.attachCouplers('rooflatch_l')
            beamstate.attachCouplers('rooflatch_r')
            beamstate.attachCouplers('klapkalatch')
            if roofLatchingTimer <= 0 then
                roofLatchingTimer = roofLatchingTime
            end
        end
    end

    --close roof stage 3
    if roofLatchingTimer > 0 then
        roofLatchingTimer = roofLatchingTimer - dt
        if roofLatchingTimer < 0 then
            roofLatchingTimer = 0
            beamstate.attachCouplers('rooflatchr_l')
            beamstate.attachCouplers('rooflatchr_r')
            roofClosed = true
        end
    end

end


local function onCouplerAttached(nodeId, obj2id, obj2nodeId, attachForce)

    local aggressionCoef = linearScale(attachForce, 0.1, 1, 0, 1)
    for _, c in pairs(frontCouplers) do
        if v.data.nodes[nodeId].name == c then
            obj:playSFXOnceCT(latchSound, soundNode1, 0.25, 0.5, aggressionCoef, 0)
        end
    end

    for _, c in pairs(rearCouplers) do
        if v.data.nodes[nodeId].name == c then
           obj:playSFXOnceCT(latchSound, soundNode2, 0.5, 0.5, aggressionCoef, 0)
        end
    end

    for _, c in pairs(coverCouplers) do
        if v.data.nodes[nodeId].name == c then
            obj:playSFXOnceCT(latchSound, soundNode3, 1, 0.5, aggressionCoef, 0)
        end
    end

end


local function onCouplerDetached(nodeId, obj2id, obj2nodeId, breakForce)

    for _, c in pairs(frontCouplers) do
        if v.data.nodes[nodeId].name == c then
            if breakForce > 0 then
                roofBroken = true
                return
            else
                obj:playSFXOnceCT(unlatchSound, soundNode1, 0.25, 0.5, 1, 0)
            end
        end
    end

    for _, c in pairs(rearCouplers) do
        if v.data.nodes[nodeId].name == c then
            if breakForce > 0 then
                roofBroken = true
                return
            else
                obj:playSFXOnceCT(unlatchSound, soundNode2, 0.5, 0.5, 1, 0)
            end
        end
    end

    for _, c in pairs(coverCouplers) do
        if v.data.nodes[nodeId].name == c then
            if breakForce > 0 then
                roofBroken = true
                return
            else
                obj:playSFXOnceCT(unlatchSound, soundNode3, 1, 0.5, 1, 0)
            end
        end
    end

end


local function reset(jbeamData)

    electrics.values.toggle_roof = 0
    electrics.values.roof_position = 0
    electrics.values.sidewindows_down = 0

    roofUnlatchingTimer = 0
    roofHidingTimer = 0
    roofClosingTimer = 0
    roofLatchingTimer = 0
    roofClosed = true
    roofOpen = false
    roofBroken = false

end


local function init(jbeamData)

    soundNode1 = jbeamData.soundNode_nodes and jbeamData.soundNode_nodes[1] or 0
    soundNode2 = jbeamData.soundNode_nodes and jbeamData.soundNode_nodes[2] or 0
    soundNode3 = jbeamData.soundNode_nodes and jbeamData.soundNode_nodes[3] or 0
    frontCouplers = jbeamData.frontCouplers
    rearCouplers = jbeamData.rearCouplers
    coverCouplers = jbeamData.coverCouplers

    reset()

end


M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

return M