-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['lifter_F'] = 0
  electrics.values['lifter_F_input'] = 0
  electrics.values['lifter_R'] = 0
  electrics.values['lifter_R_input'] = 0
  electrics.values['shoot'] = 0
end

local function updateGFX(dt) -- ms
  electrics.values['lifter_F'] = math.min(1, math.max(-0.0, (electrics.values['lifter_F'] + electrics.values['lifter_F_input'] * dt * 0.2)))
  electrics.values['lifter_R'] = math.min(1, math.max(-0.0, (electrics.values['lifter_R'] + electrics.values['lifter_R_input'] * dt * 0.2)))
end

local function liftBarrel(part, value)
  if part == "F" then electrics.values.lifter_F_input = value end
  if part == "R" then electrics.values.lifter_R_input = value end
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.fire      = fire
M.liftBarrel = liftBarrel

return M
