-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
--Mandatory controller parameters
M.type = "auxiliary"
M.relevantDevice = nil
M.engineInfo = {}
M.cat_gearboxInfo = {isReverse = false}
M.fireEngineTemperature = 0
M.throttle = 0
M.brake = 0
M.clutchRatio = 0

local min = math.min
local max = math.max

local function toggleHydraulics()
  if electrics.values.hydraulics == 0 then
	electrics.values.hydraulics = 1
  elseif electrics.values.hydraulics == 1 then
	electrics.values.hydraulics = -1	
  elseif electrics.values.hydraulics == -1 then
	electrics.values.hydraulics = 0		
  end
end

local function updateGFX(dt)
  
  if electrics.values.hydraulics_frontleft == 1 then
    electrics.values.hydraulics_FL = 1
  else
	electrics.values.hydraulics_FL = electrics.values.hydraulics
  end
  
  if electrics.values.hydraulics_frontright == 1 then
    electrics.values.hydraulics_FR = 1
  else
	electrics.values.hydraulics_FR = electrics.values.hydraulics
  end 
  
  if electrics.values.hydraulics_rearleft == 1 then
    electrics.values.hydraulics_RL = 1
  else
	electrics.values.hydraulics_RL = electrics.values.hydraulics
  end  
  
  if electrics.values.hydraulics_rearright == 1 then
    electrics.values.hydraulics_RR = 1
  else
	electrics.values.hydraulics_RR = electrics.values.hydraulics
  end    
end

local function init(jbeamData)
	electrics.values.hydraulics_frontleft = 0
	electrics.values.hydraulics_frontright = 0
	electrics.values.hydraulics_rearleft = 0
	electrics.values.hydraulics_rearright = 0
	
	electrics.values.hydraulics_up = 0
	electrics.values.hydraulics_down = 0
	electrics.values.hydraulics_F = 0
	electrics.values.hydraulics_R = 0	
	electrics.values.hydraulics = 0
end

M.init = init
M.updateGFX = updateGFX
M.toggleHydraulics = toggleHydraulics
--M.onReset  = reset

--Mandatory main controller API
M.shiftUp = nop
M.shiftDown = nop
M.shiftTocat_gearIndex = nop
M.cyclecat_gearboxModes = nop
M.setStarter = nop
M.freeze = nop
M.sendTorqueData = nop
-------------------------------

return M