-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://BeamNG.com/bCDDL-1.1.txt

local M = {}

local function onInit()
  electrics.values.gear_xNMEx3_P = 0
  electrics.values.gear_xNMEx3_R = 0
  electrics.values.gear_xNMEx3_N = 0
  electrics.values.gear_xNMEx3_D = 0
  electrics.values.gear_xNMEx3_S = 0
  electrics.values.gear_xNMEx3_M = 0
end

local function updateGFX(dt)
  electrics.values.gear_xNMEx3_P = (electrics.values.gear == "P") and 1 or 0
  electrics.values.gear_xNMEx3_R = (electrics.values.gear == "R") and 1 or 0
  electrics.values.gear_xNMEx3_N = (electrics.values.gear == "N") and 1 or 0
  electrics.values.gear_xNMEx3_D = (electrics.values.gear == "D") and 1 or 0
  electrics.values.gear_xNMEx3_S = (not electrics.values.gear:match("S") == false) and 1 or 0
  electrics.values.gear_xNMEx3_M = (not electrics.values.gear:match("M") == false) and 1 or 0
end

-- public interface
M.onInit = onInit
M.onReset = onInit
M.updateGFX = updateGFX

return M