local M = {}

local device = nil
local timer = 0
local timer2 = 0
local timer3 = 0
local timer4 = 0
local hasBeenActive = 0
local hasBeenActive2 = 0
local hasBeenActive3 = 0
local keySaveValue = 0
local indicatorActive = false
local timer_ind = 0
local indicator_l = false
local indicator_r = false
local indicator_lr = false
local shifterSmoother = newExponentialSmoothing(10)
local cabinFilterCoef = 1
local cabinFilterChanged = false
local keySmoother = newExponentialSmoothing(10)
local keyPos = 0
local automaticShifterPos = 0
local doorFL = nil
local doorFR = nil
local doorRL = nil
local doorRR = nil
local hood = nil
local tailgate = nil
local doorsOpen = 0
local doorStateChanged = 0
local doorMissing = false
local buttonPress
local keyPosCache = 1
local Chime_play = false
local myTimer = 0

local function lerp(a,b,t) 
    return a * (1-t) + b * t 
end

function round(num, numDecimalPlaces)
  local mult = 10^(numDecimalPlaces or 0)
  return math.floor(num * mult + 0.5) / mult
end

local function onInit()

	timer4 = 0
	indicatorActive = false
	timer_ind = 0
	indicator_l = false
	indicator_r = false
	indicator_lr = false
	obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 1))

	electrics.values.door_projector_FR = 0
	electrics.values.door_projector_FL = 0
	electrics.values.door_projector_RR = 0
	electrics.values.door_projector_RL = 0
end

local function onInit(jbeamData)
	sounds.createSFXSource("vehicles/fadx6m/chime.ogg", 'AudioDefault3D', "ChimeLoop", v.data.refNodes[0].ref)
end

local function onReset()
	onInit()
end

local function updateGFX(dt) 
    sounds.updateCabinFilter()
	
	local function chime_sound()
		if Chime_play == true then
			--print("Sound!!")
			sounds.playSoundOnceAtNode("ChimeLoop", v.data.refNodes[0].ref, 3)
			Chime_play = false
		end
	end

	local function timer()
		myTimer = myTimer + 0.01
		if myTimer >= 0.75 then
			myTimer = 0
			Chime_play = true
		end
	end
	
	--Startup Chime
	if electrics.values.ignitionLevel > 2 then	
		chime_sound()
		timer()
	else
		Chime_play = true
	end
	
	--Dome Light
	if doorFR == 1 or doorFL == 1 or doorRR == 1 or doorRL == 1 or tailgate == 1 then	
		electrics.values["domelight"] = 1
	else
		electrics.values["domelight"] = 0
	end

	--Sunroof
	if electrics.values.windowSRT == 1 then
		electrics.values.windowSR = 0
	end
	
	--Door Projector
	if doorFL == 1 then
		electrics.values.door_projector_FL = 1
		else
		if doorFL == 0 then
		electrics.values.door_projector_FL = 0
		end
	end
	if doorFR == 1 then
		electrics.values.door_projector_FR = 1
		else
		if doorFR == 0 then
		electrics.values.door_projector_FR = 0
		end
	end
	if doorRL == 1 then
		electrics.values.door_projector_RL = 1
		else
		if doorRL == 0 then
		electrics.values.door_projector_RL = 0
		end
	end
	if doorRR == 1 then
		electrics.values.door_projector_RR = 1
		else
		if doorRR == 0 then
		electrics.values.door_projector_RR = 0
		end
	end

		--Door and Sunroof tilt Cabin filter
		if playerInfo.anyPlayerSeated and doorFR == 1 or doorFL == 1 or doorRR == 1 or doorRL == 1 or electrics.values.windowSRT == 1 or electrics.values.windowSRT_2 == 1 then				

					cabinFilterChanged = true
					obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 0))

		end

		--Window and Sunroof Cabin filter
		if playerInfo.anyPlayerSeated and electrics.values.windowFR == 1 or electrics.values.windowFL == 1 or electrics.values.windowRR == 1 or electrics.values.windowRL == 1 or electrics.values.windowSR == 1 then				

			cabinFilterChanged = true
			timer4 = timer4 + 0.01
			obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 0))

		else
		
			timer4 = timer4 - 0.01

		end
		
		--All Cabin filters off
		
		if playerInfo.anyPlayerSeated and doorFR == 0 and doorFL == 0 and doorRR == 0 and doorRL == 0 and electrics.values.windowSRT == 0 and electrics.values.windowSRT_2 == 0 then				

			if timer4 <= 0 then
				cabinFilterChanged = false
				obj:queueGameEngineLua(string.format("core_sounds.cabinFilterStrength = %f", 1))
			end

		end
		
					if timer4 >= 2.15 then
						timer4 = 2.15
					end
					
					if timer4 <= 0 then
						timer4 = 0
					end
	  
	if not electrics.values["isSimpleTrafficCar"] then
		--Make sure this code is only excecuted when the car is not a simple traffic car to save on resources

		--Door open detection logic as well as domelight and cabin filter logic
		--set to 1 when doesnt exist

		if electrics.values["doorFLCoupler_notAttached"] then
			doorFL = electrics.values["doorFLCoupler_notAttached"]
		else
			doorMissing = true
		end
		if electrics.values["doorFRCoupler_notAttached"] then
			doorFR = electrics.values["doorFRCoupler_notAttached"]
		else
			doorMissing = true
		end
		if electrics.values["doorRLCoupler_notAttached"] then
			doorRL = electrics.values["doorRLCoupler_notAttached"]
		else
			doorMissing = true
		end
		if electrics.values["doorRRCoupler_notAttached"] then
			doorRR = electrics.values["doorRRCoupler_notAttached"]
		else
			doorMissing = true
		end
		if electrics.values["tailgateCoupler_notAttached"] then
			tailgate = electrics.values["tailgateCoupler_notAttached"]
		else
			tailgate = 1
		end
		if electrics.values["hoodLatchCoupler_notAttached"] then
			hood = electrics.values["hoodLatchCoupler_notAttached"]
		else
			hood = 1
		end

		if doorsOpen == 1 or tailgate == 1 or hood == 1 then
			if electrics.values["ignitionLevel"] > 0 then electrics.values["doorsOpen"] = 1 end 
		else
			electrics.values["doorsOpen"] = 0

		end

	  --Automatic shifter

	  if device == nil then return end -- prevent lua error when engine removed
	  --if device.starterEngagedCoef == nil then return end
	  if device.starterEngagedCoef ~= nil and device.starterEngagedCoef ~= 0 and not device.isDisabled then 
		hasBeenActive = 1
		hasBeenActive2 = 1
		hasBeenActive3 = 1

		electrics.values["startermotor"] = 1
		electrics.values["startermotor2"] = 1
		electrics.values["startermotor3"] = 1

		--else
		--electrics.values["startermotor"] = 0
	  end
	  if hasBeenActive == 1 then
		timer = timer + dt		
		if timer >= 1.5 then
			electrics.values["startermotor"] = 0
			hasBeenActive = 0
			timer = 0
		end
	  end
	  if hasBeenActive2 == 1 then
		timer2 = timer2 + dt	
		if timer2 >= 2.5 then
			electrics.values["startermotor2"] = 0
			hasBeenActive2 = 0
			timer2 = 0
		end
	  end
	  if hasBeenActive3 == 1 then	
		timer3 = timer3 + dt	
		if timer3 >= 4.5 then
			electrics.values["startermotor3"] = 0
			hasBeenActive3 = 0
			timer3 = 0
		end
	  end
	  
	 --car key twisting function 

		if device.starterEngagedCoef ~= 0 and not device.isDisabled then
			keyPos = 1
			electrics.values["key"] = keySmoother:get(keyPos)
		elseif electrics.values["engineRunning"] == 1 or electrics.values["ignitionLevel"] >= 1 then
			keyPos = 0.7
			electrics.values["key"] = keySmoother:get(keyPos)
		else
			keyPos = 0
			electrics.values["key"] = keySmoother:get(keyPos)
		end

		if round(electrics.values["key"], 2) == keyPos and keyPos ~= keyPosCache then
			buttonPress = buttonPress or sounds.createSoundscapeSound("ButtonPress")
			sounds.playSoundSkipAI(buttonPress)
			keyPosCache = keyPos
		end
	
	end
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M